/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.commands.Plugins;
import org.vcs.bazaar.client.commandline.commands.Version;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.internal.ShellCommandRunner;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;
import org.vcs.bazaar.client.xmlrpc.XmlRpcMethod;
import org.vcs.bazaar.client.xmlrpc.internal.DummyCommand;
import org.vcs.bazaar.client.xmlrpc.internal.DummyCommandRunner;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCCommandRunner;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCServer;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcStruct;

public class XMLRPCCommandRunnerTest
extends BazaarTest {
    private XMLRPCCommandRunner xmlRpcRunner;
    private ShellCommandRunner shellRunner;

    @Before
    public void configureRunners() {
        this.xmlRpcRunner = new XMLRPCCommandRunner(XMLRPCServer.getInstance((BazaarClientPreferences)BazaarClientPreferences.getInstance()));
        this.shellRunner = new ShellCommandRunner();
    }

    @Test
    public void testRunCommand() throws BazaarClientException {
        Version cmd = new Version();
        this.xmlRpcRunner.runCommand((Command)cmd, this.getTempDir());
        Integer exitVal = this.xmlRpcRunner.result.getIntegerWrapper(0);
        String stdOut = new String(this.xmlRpcRunner.result.getBinary(1));
        String stdErr = this.xmlRpcRunner.result.getString(2);
        Assert.assertNotNull((Object)exitVal);
        Assert.assertEquals((Object)0, (Object)exitVal);
        Assert.assertNotNull((Object)stdOut);
        Assert.assertNotNull((Object)stdErr);
        Assert.assertEquals((Object)"", (Object)stdErr);
    }

    @Test
    public void testRunCommandWithError() throws BazaarClientException {
        Command cmd = new Command(){

            public String getCommand() {
                return "versionxml";
            }

            protected List<String> getArguments() throws CommandLineException {
                return new ArrayList<String>();
            }
        };
        try {
            this.xmlRpcRunner.runCommand(cmd, this.getTempDir());
        }
        catch (XmlRpcCommandException e) {
            IBzrError error = e.getCommandError();
            Assert.assertEquals((Object)error.getType(), (Object)"BzrCommandError");
            Assert.assertEquals((Object)error.getMessage(), (Object)"unknown command \"versionxml\"");
        }
    }

    @Test
    public void testExecuteMethod() throws BazaarClientException {
        XmlRpcMethod method = new XmlRpcMethod("hello", new Object[0]);
        Object result = this.xmlRpcRunner.executeMethod(method);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)"world!");
    }

    @Test
    public void testSearch() throws Exception {
        if (!this.checkSearchPlugin()) {
            return;
        }
        Environment env = new Environment("xmlrpc-search", this.getTestConfig());
        Command cmd = new Command(){

            public String getCommand() {
                return "index";
            }

            protected List<String> getArguments() throws CommandLineException {
                return new ArrayList<String>();
            }
        };
        File workDir = env.getWorkingTreeLocation();
        this.shellRunner.runCommand(cmd, workDir);
        XmlRpcMethod method = new XmlRpcMethod("search", new Object[]{BazaarUtilities.unixFilePath((File)env.getWorkingTreeLocation()), new String[]{"a", "file", "in"}});
        Object retVal = this.xmlRpcRunner.executeMethod(method);
        Assert.assertEquals(retVal.getClass(), XmlRpcStruct.class);
        XmlRpcStruct result = (XmlRpcStruct)retVal;
        Assert.assertNotNull((Object)result);
        XmlRpcArray fileHits = result.getArray((Object)"file_hits");
        XmlRpcArray revIdHits = result.getArray((Object)"revid_hits");
        XmlRpcArray pathHits = result.getArray((Object)"path_hits");
        Assert.assertNotNull((Object)revIdHits);
        Assert.assertNotNull((Object)fileHits);
        Assert.assertNotNull((Object)pathHits);
        Assert.assertNull((Object)method.getError());
        Assert.assertEquals((String)"Expected file hits", (long)6L, (long)fileHits.size());
    }

    @Test
    public void testGetStandardOutput() throws UnsupportedEncodingException, BazaarClientException {
        this.testOutput(OutputType.STANDARD);
    }

    @Test
    public void testGetStandardError() throws UnsupportedEncodingException, BazaarClientException {
        this.testOutput(OutputType.ERROR);
    }

    private String getOutput(Command command, OutputType type) {
        switch (type) {
            case STANDARD: {
                return command.getStandardOutput();
            }
            case ERROR: {
                return command.getStandardError();
            }
        }
        return null;
    }

    private String sampleXML(String encoding, String content) {
        return String.format("<?xml version=\"1.0\" encoding=\"%s\"?><hello>%s</hello>", encoding, content);
    }

    private void testOutput(OutputType outputType) throws BazaarClientException, UnsupportedEncodingException {
        String NON_XML = "Raw";
        String NON_ASCII = "Ma\u00e7\u00e3";
        String NON_ASCII_DECODED_FROM_UTF8_BYTES_AS_LATIN1 = "Ma\u00c3\u00a7\u00c3\u00a3";
        DummyCommand dummyCommand = new DummyCommand();
        DummyCommandRunner dummyRunner = new DummyCommandRunner();
        dummyCommand.execute((CommandRunner)dummyRunner);
        dummyRunner.setDummyOutput("Raw".getBytes("UTF-8"), "Raw");
        Assert.assertEquals((Object)"Raw", (Object)this.getOutput(dummyCommand, outputType));
        String declaredAsUTF8 = this.sampleXML("UTF-8", "Ma\u00e7\u00e3");
        dummyRunner.setDummyOutput(declaredAsUTF8.getBytes("UTF-8"), declaredAsUTF8);
        dummyCommand.execute((CommandRunner)dummyRunner);
        Assert.assertEquals((String)"Ouptut bytes should be decoded as UTF-8", (Object)declaredAsUTF8, (Object)this.getOutput(dummyCommand, outputType));
        String declaredAsLatin1 = this.sampleXML("ISO-8859-1", "Ma\u00e7\u00e3");
        String utf8DecodedAsLatin1 = declaredAsLatin1.replaceAll("Ma\u00e7\u00e3", "Ma\u00c3\u00a7\u00c3\u00a3");
        dummyRunner.setDummyOutput(declaredAsLatin1.getBytes("UTF-8"), utf8DecodedAsLatin1);
        dummyCommand.execute((CommandRunner)dummyRunner);
        Assert.assertEquals((String)"Output bytes should be UTF-8 decoded as Latin-1", (Object)utf8DecodedAsLatin1, (Object)this.getOutput(dummyCommand, outputType));
    }

    private boolean checkSearchPlugin() throws BazaarClientException {
        Plugins cmd = new Plugins();
        cmd.execute((CommandRunner)this.xmlRpcRunner);
        for (IPlugin plugin : new XMLPluginParser().parse(cmd.getStandardOutput())) {
            if (plugin.getName() == null || !plugin.getName().contains("search")) continue;
            return true;
        }
        return false;
    }

    private File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputType {
        STANDARD,
        ERROR;

    }
}

