/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.vcs.bazaar.client.IBazaarNotifyListener;

public class BazaarNotificationHandler {
    protected final List<IBazaarNotifyListener> notifylisteners = new ArrayList<IBazaarNotifyListener>();
    protected int command;
    protected boolean logEnabled = true;
    protected boolean debugEnabled = true;

    public void add(IBazaarNotifyListener listener) {
        this.notifylisteners.add(listener);
    }

    public void remove(IBazaarNotifyListener listener) {
        this.notifylisteners.remove(listener);
    }

    public void enableLog() {
        this.logEnabled = true;
    }

    public void disableLog() {
        this.logEnabled = false;
    }

    public void logMessage(String message) {
        if (this.logEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logMessage(message);
            }
        }
    }

    public void logError(String message) {
        if (this.logEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logError(message);
            }
        }
    }

    public void logRevision(long revision, String path) {
        if (this.logEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logRevision(revision, path);
            }
        }
    }

    public void logCompleted(String message) {
        if (this.logEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logCompleted(message);
            }
        }
    }

    public void setCommand(int command) {
        this.command = command;
        for (IBazaarNotifyListener listener : this.notifylisteners) {
            listener.setCommand(command);
        }
    }

    public void logCommandLine(String commandLine) {
        if (this.logEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logCommandLine(commandLine);
            }
        }
    }

    public void logCommandOutput(String message) {
        if (this.logEnabled && this.debugEnabled) {
            for (IBazaarNotifyListener listener : this.notifylisteners) {
                listener.logCommandOutput(message);
            }
        }
    }

    public void logException(Exception clientException) {
        if (this.logEnabled) {
            for (Throwable e = clientException; e != null; e = e.getCause()) {
                this.logError(e.getMessage());
            }
        }
    }

    public void notifyListenersOfChange(String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        for (IBazaarNotifyListener listener : this.notifylisteners) {
            listener.onNotify(file);
        }
    }
}

