/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import java.util.Date;
import org.vcs.bazaar.client.IBazaarInfo;

public class CommandLineInfo
implements IBazaarInfo {
    private static final long serialVersionUID = 5462220750851543669L;
    private final String layout;
    private final String[] formats;
    private final String branchFormat;
    private final String controlFormat;
    private final String repositoryFormat;
    private final String workingTreeFormat;
    private final CmdLineLocations locations;
    private final CmdLineRelatedBranches relatedBranches;
    private final CmdLineWorkingTreeStats workingTreeStats;
    private final CmdLineBranchHistory branchHistory;
    private final CmdLineRepositoryStats repositoryStats;

    public CommandLineInfo(String layout, String[] formats, String branchFormat, String controlFormat, String repositoryFormat, String workingTreeFormat, CmdLineLocations locations, CmdLineRelatedBranches relatedBranches, CmdLineWorkingTreeStats workingTreeStats, CmdLineBranchHistory branchHistory, CmdLineRepositoryStats repositoryStats) {
        this.layout = layout;
        this.formats = formats;
        this.branchFormat = branchFormat;
        this.controlFormat = controlFormat;
        this.repositoryFormat = repositoryFormat;
        this.workingTreeFormat = workingTreeFormat;
        this.locations = locations;
        this.relatedBranches = relatedBranches;
        this.workingTreeStats = workingTreeStats;
        this.branchHistory = branchHistory;
        this.repositoryStats = repositoryStats;
    }

    public IBazaarInfo.BranchHistory getBranchHistory() {
        return this.branchHistory;
    }

    public String[] getFormats() {
        return this.formats;
    }

    public String getBranchFormat() {
        return this.branchFormat;
    }

    public String getControlFormat() {
        return this.controlFormat;
    }

    public String getRepositoryFormat() {
        return this.repositoryFormat;
    }

    public String getWorkingTreeFormat() {
        return this.workingTreeFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public IBazaarInfo.Locations getLocations() {
        return this.locations;
    }

    public IBazaarInfo.RelatedBranches getRelatedBranches() {
        return this.relatedBranches;
    }

    public IBazaarInfo.RepositoryStats getRepositoryStats() {
        return this.repositoryStats;
    }

    public IBazaarInfo.WorkingTreeStats getWorkingTreeStats() {
        return this.workingTreeStats;
    }

    public static class CmdLineLocations
    implements IBazaarInfo.Locations {
        private final String lightCheckoutRoot;
        private final String repositoryCheckoutRoot;
        private final String checkoutRoot;
        private final String checkoutOfBranch;
        private final String sharedRepository;
        private final String repository;
        private final String repositoryBranch;
        private final String branchRoot;
        private final String boundToBranch;

        public CmdLineLocations(String lightCheckoutRoot, String repositoryCheckoutRoot, String checkoutRoot, String checkoutOfBranch, String sharedRepository, String repository, String repositoryBranch, String branchRoot, String boundToBranch) {
            this.lightCheckoutRoot = lightCheckoutRoot;
            this.repositoryCheckoutRoot = repositoryCheckoutRoot;
            this.checkoutRoot = checkoutRoot;
            this.checkoutOfBranch = checkoutOfBranch;
            this.sharedRepository = sharedRepository;
            this.repository = repository;
            this.repositoryBranch = repositoryBranch;
            this.branchRoot = branchRoot;
            this.boundToBranch = boundToBranch;
        }

        public String getLightCheckoutRoot() {
            return this.lightCheckoutRoot;
        }

        public String getRepositoryCheckoutRoot() {
            return this.repositoryCheckoutRoot;
        }

        public String getCheckoutRoot() {
            return this.checkoutRoot;
        }

        public String getCheckoutOfBranch() {
            return this.checkoutOfBranch;
        }

        public String getSharedRepository() {
            return this.sharedRepository;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getRepositoryBranch() {
            return this.repositoryBranch;
        }

        public String getBranchRoot() {
            return this.branchRoot;
        }

        public String getBoundToBranch() {
            return this.boundToBranch;
        }
    }

    public static class CmdLineRepositoryStats
    implements IBazaarInfo.RepositoryStats {
        private final Integer repositoryRevisions;
        private final Long repositorySize;

        public CmdLineRepositoryStats(Integer repositoryRevisions, Long repositorySize) {
            this.repositoryRevisions = repositoryRevisions;
            this.repositorySize = repositorySize;
        }

        public Integer getRevisionCount() {
            return this.repositoryRevisions;
        }

        public Long getSize() {
            return this.repositorySize;
        }
    }

    public static class CmdLineBranchHistory
    implements IBazaarInfo.BranchHistory {
        private final Integer branchRevisions;
        private final Integer committers;
        private final Integer daysOld;
        private final Date firstRevisionDate;
        private final Date latestRevisionDate;

        public CmdLineBranchHistory(Integer branchRevisions, Integer committers, Integer daysOld, Date firstRevisionDate, Date latestRevisionDate) {
            this.branchRevisions = branchRevisions;
            this.committers = committers;
            this.daysOld = daysOld;
            this.firstRevisionDate = firstRevisionDate;
            this.latestRevisionDate = latestRevisionDate;
        }

        public Integer getRevisions() {
            return this.branchRevisions;
        }

        public Integer getCommitters() {
            return this.committers;
        }

        public Date getFirstRevisionDate() {
            return this.firstRevisionDate;
        }

        public Date getLatestRevisionDate() {
            return this.latestRevisionDate;
        }

        public Integer getDaysOld() {
            return this.daysOld;
        }
    }

    public static class CmdLineWorkingTreeStats
    implements IBazaarInfo.WorkingTreeStats {
        private final Integer added;
        private final Integer ignored;
        private final Integer modified;
        private final Integer removed;
        private final Integer renamed;
        private final Integer unchanged;
        private final Integer unknown;
        private final Integer versionedSubdirectories;

        public CmdLineWorkingTreeStats(Integer added, Integer ignored, Integer modified, Integer removed, Integer renamed, Integer unchanged, Integer unknown, Integer versionedSubdirectories) {
            this.added = added;
            this.ignored = ignored;
            this.modified = modified;
            this.removed = removed;
            this.renamed = renamed;
            this.unchanged = unchanged;
            this.unknown = unknown;
            this.versionedSubdirectories = versionedSubdirectories;
        }

        public Integer getAdded() {
            return this.added;
        }

        public Integer getIgnored() {
            return this.ignored;
        }

        public Integer getModified() {
            return this.modified;
        }

        public Integer getRemoved() {
            return this.removed;
        }

        public Integer getRenamed() {
            return this.renamed;
        }

        public Integer getUnchanged() {
            return this.unchanged;
        }

        public Integer getUnknown() {
            return this.unknown;
        }

        public Integer getVersionedSubdirectories() {
            return this.versionedSubdirectories;
        }
    }

    public static class CmdLineRelatedBranches
    implements IBazaarInfo.RelatedBranches {
        private final String publicBranch;
        private final String pushBranch;
        private final String parentBranch;
        private final String submitBranch;

        public CmdLineRelatedBranches(String publicBranch, String pushBranch, String parentBranch, String submitBranch) {
            this.publicBranch = publicBranch;
            this.pushBranch = pushBranch;
            this.parentBranch = parentBranch;
            this.submitBranch = submitBranch;
        }

        public String getParentBranch() {
            return this.parentBranch;
        }

        public String getPublicBranch() {
            return this.publicBranch;
        }

        public String getPushBranch() {
            return this.pushBranch;
        }

        public String getSubmitBranch() {
            return this.submitBranch;
        }
    }
}

