/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiFileCommand
extends Command {
    protected final File[] resources;

    public MultiFileCommand(File workDir, File[] files) {
        super(workDir);
        this.resources = files;
    }

    @Override
    public void execute(CommandRunner runner) throws BazaarClientException {
        if (this.shouldExecute()) {
            super.execute(runner);
        }
    }

    protected boolean shouldExecute() {
        return this.resources.length > 0;
    }

    @Override
    protected List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (File f : this.resources) {
            args.add(this.getRelativeToWorkDir(f).getPath());
        }
        return args;
    }

    @Override
    public int getEstimatedWork() {
        return this.resources.length;
    }
}

