/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarConflict;
import org.vcs.bazaar.client.BazaarConflictType;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConflictsParser
extends XMLParser {
    private static final String CONFLICTS = "conflicts";
    private static final String CONFLICT = "conflict";
    private static final String TYPE = "type";
    private static final String PATH = "path";
    private static final String MESSAGE = "message";

    public static List<IBazaarConflict> parse(String xml) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new StringReader(xml));
            return new XMLConflictsParser().parse(parser);
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
    }

    public List<IBazaarConflict> parse(KXmlParser aParser) throws BazaarClientException {
        ArrayList<IBazaarConflict> conflicts = new ArrayList<IBazaarConflict>();
        this.parser = aParser;
        try {
            this.parser.nextTag();
            this.parser.require(2, null, CONFLICTS);
            int eventType = this.parser.getEventType();
            while (!(eventType == 1 || eventType == 3 && CONFLICTS.equals(this.parser.getName()))) {
                IBazaarConflict conflict;
                if (eventType == 2 && CONFLICT.equals(this.parser.getName()) && (conflict = this.parseConflict()) != null) {
                    conflicts.add(conflict);
                }
                eventType = this.parser.next();
            }
            return conflicts;
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
    }

    private IBazaarConflict parseConflict() throws XmlPullParserException, IOException {
        BazaarConflictType type = BazaarConflictType.UNKNOWN;
        String path = null;
        String message = null;
        int eventType = this.parser.next();
        while (!(eventType == 1 || eventType == 3 && CONFLICT.equals(this.parser.getName()))) {
            if (eventType == 2 && TYPE.equals(this.parser.getName())) {
                type = BazaarConflictType.fromString(this.parser.nextText());
            } else if (eventType == 2 && PATH.equals(this.parser.getName())) {
                path = this.parser.nextText();
            } else if (eventType == 2 && MESSAGE.equals(this.parser.getName())) {
                message = this.parser.nextText();
            }
            eventType = this.parser.next();
        }
        return new BazaarConflict(type, path, message);
    }
}

