/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.CommandLineLogMessage;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.commandline.parser.XMLStatusParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLogParser
extends XMLParser {
    public static final String REVNO = "revno";
    public static final String REVISION_ID = "revisionid";
    public static final String COMMITER = "committer";
    public static final String BRANCH_NICK = "branch-nick";
    public static final String TIMESTAMP = "timestamp";
    public static final String MESSAGE = "message";
    public static final String LOG = "log";
    public static final String TAGS = "tags";
    public static final String TAG = "tag";
    public static final String PARENTS = "parents";
    public static final String PARENT = "parent";
    public static final String MERGE = "merge";
    public static final String FILES = "affected-files";

    public static List<IBazaarLogMessage> parse(String xml) throws BazaarClientException {
        return XMLLogParser.parse(new StringReader(xml));
    }

    public static List<IBazaarLogMessage> parse(Reader aReader) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput(aReader);
            return new XMLLogParser().parse(parser);
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
    }

    protected List<IBazaarLogMessage> parse(KXmlParser aParser) throws BazaarClientException {
        ArrayList<IBazaarLogMessage> logs = new ArrayList<IBazaarLogMessage>();
        this.parser = aParser;
        try {
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                CommandLineLogMessage log;
                if (eventType == 2 && LOG.equals(this.parser.getName()) && (log = this.parseLog()) != null) {
                    logs.add(log);
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        Collections.sort(logs, new IBazaarLogMessage.LogMessageComparator());
        return logs;
    }

    protected CommandLineLogMessage parseLog() throws XmlPullParserException, IOException {
        XMLStatusParser statusParser = new XMLStatusParser();
        String revisionId = null;
        String message = null;
        String timestamp = null;
        String nick = null;
        String commiter = null;
        String revno = null;
        List<String> parents = null;
        List<IBazaarStatus> statuses = null;
        ArrayList<IBazaarLogMessage> mergedLogs = new ArrayList<IBazaarLogMessage>();
        List<String> tags = null;
        int eventType = this.parser.next();
        while (eventType != 3 || !LOG.equals(this.parser.getName()) || eventType == 1) {
            if (eventType == 2 && REVNO.equals(this.parser.getName())) {
                revno = this.parser.nextText();
            } else if (eventType == 2 && REVISION_ID.equals(this.parser.getName())) {
                revisionId = this.parser.nextText();
            } else if (eventType == 2 && PARENTS.equals(this.parser.getName())) {
                parents = this.parseParents();
            } else if (eventType == 2 && TAGS.equals(this.parser.getName())) {
                tags = this.parseTags();
            } else if (eventType == 2 && COMMITER.equals(this.parser.getName())) {
                commiter = this.parser.nextText();
            } else if (eventType == 2 && BRANCH_NICK.equals(this.parser.getName())) {
                nick = this.parser.nextText();
            } else if (eventType == 2 && TIMESTAMP.equals(this.parser.getName())) {
                timestamp = this.parser.nextText();
            } else if (eventType == 2 && MESSAGE.equals(this.parser.getName())) {
                String rawMsg = this.parser.nextText();
                message = rawMsg != null ? rawMsg.replace("\\x0c", "\f").replace("\\x09", "\t").replace("\\x08", "\b") : "(no message)";
            } else if (eventType == 2 && MERGE.equals(this.parser.getName())) {
                mergedLogs.addAll(this.parseMergedLogs());
            } else if (eventType == 2 && FILES.equals(this.parser.getName())) {
                statuses = statusParser.parseForLog(this.parser, FILES);
            }
            eventType = this.parser.next();
        }
        return new CommandLineLogMessage(revno, commiter, null, nick, timestamp, message, statuses, mergedLogs, revisionId, parents, tags);
    }

    private List<IBazaarLogMessage> parseMergedLogs() throws XmlPullParserException, IOException {
        ArrayList<IBazaarLogMessage> logs = new ArrayList<IBazaarLogMessage>(0);
        int eventType = this.parser.next();
        int mergeCounter = 1;
        while (mergeCounter > 0) {
            if (eventType == 2 && MERGE.equals(this.parser.getName())) {
                ++mergeCounter;
            } else if (eventType == 2 && LOG.equals(this.parser.getName())) {
                logs.add(this.parseLog());
            }
            if ((eventType = this.parser.next()) != 3 || !MERGE.equals(this.parser.getName())) continue;
            --mergeCounter;
        }
        Collections.sort(logs, new IBazaarLogMessage.LogMessageComparator());
        return logs;
    }

    private List<String> parseParents() throws XmlPullParserException, IOException {
        ArrayList<String> parents = new ArrayList<String>(0);
        int eventType = this.parser.next();
        while (eventType != 3 && !PARENTS.equals(this.parser.getName())) {
            if (eventType == 2 && PARENT.equals(this.parser.getName())) {
                parents.add(this.parser.nextText());
            }
            eventType = this.parser.next();
        }
        return parents;
    }

    private List<String> parseTags() throws XmlPullParserException, IOException {
        ArrayList<String> tags = new ArrayList<String>(0);
        int eventType = this.parser.next();
        while (eventType != 3 && !TAGS.equals(this.parser.getName())) {
            if (eventType == 2 && TAG.equals(this.parser.getName())) {
                tags.add(this.parser.nextText());
            }
            eventType = this.parser.next();
        }
        return tags;
    }
}

