/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarItemInfo;
import org.vcs.bazaar.client.BazaarItemKind;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.commandline.CommandLineLogMessage;
import org.vcs.bazaar.client.commandline.parser.XMLLogParser;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLsParser
extends XMLParser {
    private static final Log LOG = LogFactory.getLog(XMLLsParser.class);
    private static final String LIST = "list";
    private static final String KIND = "kind";
    private static final String PATH = "path";
    private static final String ID = "id";
    private static final String ITEM = "item";
    private static final String STATUS_KIND = "status_kind";
    private static final String PATTERN = "pattern";

    public static List<IBazaarItemInfo> parse(String xml) {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new StringReader(xml));
            return new XMLLsParser().parse(parser);
        }
        catch (XmlPullParserException e) {
            LOG.error((Object)"XML parsing failed", (Throwable)e);
            return new ArrayList<IBazaarItemInfo>(0);
        }
    }

    private List<IBazaarItemInfo> parse(KXmlParser parser) {
        this.parser = parser;
        ArrayList<IBazaarItemInfo> result = new ArrayList<IBazaarItemInfo>();
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                IBazaarItemInfo item;
                if (eventType == 2 && !parser.getName().equals(LIST) && parser.getName().equals(ITEM) && (item = this.parseItem()) != null) {
                    result.add(item);
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            LOG.error((Object)"XML parsing failed", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO trouble while parsing XML", (Throwable)e);
        }
        return result;
    }

    private IBazaarItemInfo parseItem() throws XmlPullParserException, IOException {
        BazaarItemKind kind = null;
        String id = null;
        String path = null;
        BazaarStatusKind type = null;
        String pattern = null;
        XMLLogParser logParser = new XMLLogParser();
        logParser.parser = this.parser;
        CommandLineLogMessage log = null;
        int eventType = this.parser.getEventType();
        do {
            switch (eventType) {
                case 2: {
                    if (KIND.equals(this.parser.getName())) {
                        kind = BazaarItemKind.fromString(this.parser.nextText());
                    }
                    if (PATH.equals(this.parser.getName())) {
                        path = this.parser.nextText();
                    }
                    if (ID.equals(this.parser.getName())) {
                        id = this.parser.nextText();
                    }
                    if (STATUS_KIND.equals(this.parser.getName())) {
                        type = BazaarStatusKind.fromString(this.parser.nextText());
                    }
                    if (PATTERN.equals(this.parser.getName())) {
                        pattern = this.parser.nextText();
                    }
                    if (!"log".equals(this.parser.getName())) break;
                    log = logParser.parseLog();
                }
            }
        } while (3 != (eventType = this.parser.next()) || !ITEM.equals(this.parser.getName()));
        return new BazaarItemInfo(kind, id, path, type, pattern, log);
    }
}

