/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.List;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.IBazaarUserPassword;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.internal.IProgressListenerAware;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.xmlrpc.BzrXmlRpcError;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;
import org.vcs.bazaar.client.xmlrpc.XmlRpcMethod;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCServer;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcClient;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRPCCommandRunner
extends CommandRunner {
    private final XMLRPCServer server;
    protected XmlRpcArray result;

    public XMLRPCCommandRunner(XMLRPCServer server) {
        this(server, BazaarClientPreferences.getInstance());
    }

    public XMLRPCCommandRunner(XMLRPCServer server, BazaarClientPreferences preferences) {
        super(preferences);
        this.server = server;
    }

    private XmlRpcArray runCommand(Command command, boolean checkExitValue, File workDir) throws XmlRpcCommandException {
        List<String> cmdLine;
        XMLRPCProgressMonitor monitor = null;
        try {
            cmdLine = command.constructCommandInvocationString();
        }
        catch (CommandLineException e) {
            throw XmlRpcCommandException.wrapException((Exception)e);
        }
        if (command instanceof IProgressListenerAware && ((IProgressListenerAware)((Object)command)).getProgressListener() != null) {
            monitor = new XMLRPCProgressMonitor(cmdLine, ((IProgressListenerAware)((Object)command)).getProgressListener());
            monitor.start();
        }
        cmdLine.addAll(0, BazaarClientPreferences.getExecutable(false));
        try {
            this.server.startCommand();
            try {
                Object[] params = new Object[]{cmdLine, workDir != null ? workDir.getPath() : new File(".").getCanonicalPath()};
                XmlRpcArray xmlRpcArray = this.runCommand(checkExitValue, "run_bzr", params);
                return xmlRpcArray;
            }
            catch (XmlRpcCommandException e) {
                try {
                    XmlRpcArray xmlRpcArray = this.handleAuthorizationErrors(checkExitValue, workDir, cmdLine, e);
                    this.server.endCommand();
                    if (monitor != null) {
                        monitor.stop();
                    }
                    return xmlRpcArray;
                }
                catch (IOException e2) {
                    throw XmlRpcCommandException.wrapException(e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.server.endCommand();
            if (monitor != null) {
                monitor.stop();
            }
        }
    }

    private XmlRpcArray handleAuthorizationErrors(boolean checkExitValue, File workDir, List<String> cmdLine, XmlRpcCommandException e) throws IOException, XmlRpcCommandException {
        boolean passwordOnly;
        String prompt;
        IBazaarUserPassword credentials;
        String msg = e.getMessage();
        if (msg != null && msg.startsWith("XMLRPC authentication") && this.userPasswordPrompt != null && (credentials = this.userPasswordPrompt.getCredentials(prompt = this.getUserPasswordPromptMessage(cmdLine, msg), passwordOnly = e.getMessage().startsWith("XMLRPC authentication password"), false)) != null) {
            String user = credentials.getUser() != null ? credentials.getUser() : "";
            String password = credentials.getPassword() != null ? credentials.getPassword() : "";
            Object[] params = new Object[]{cmdLine, workDir != null ? workDir.getPath() : new File(".").getCanonicalPath(), user, password};
            try {
                return this.runCommand(checkExitValue, "run_bzr_auth", params);
            }
            catch (XmlRpcCommandException e1) {
                if (credentials.isStored()) {
                    credentials = this.userPasswordPrompt.getCredentials(prompt, passwordOnly, true);
                    if (credentials != null) {
                        user = credentials.getUser() != null ? credentials.getUser() : "";
                        password = credentials.getPassword() != null ? credentials.getPassword() : "";
                        params = new Object[]{cmdLine, workDir != null ? workDir.getPath() : new File(".").getCanonicalPath(), user, password};
                        return this.runCommand(checkExitValue, "run_bzr_auth", params);
                    }
                }
                throw e1;
            }
        }
        throw e;
    }

    private String getUserPasswordPromptMessage(List<String> cmdLine, String msg) {
        int index = msg.indexOf(58);
        String prompt = "";
        if (index >= 0 && index + 1 < msg.length()) {
            prompt = msg.substring(index);
        }
        if (cmdLine.size() > 1) {
            String branchLocation = cmdLine.get(cmdLine.size() - 1);
            if (cmdLine.size() > 2 && (cmdLine.get(1).equals("branch") || cmdLine.get(1).equals("checkout"))) {
                branchLocation = cmdLine.get(2);
            }
            try {
                BranchLocation location = new BranchLocation(branchLocation);
                prompt = location.toString();
            }
            catch (BazaarClientException e1) {
                // empty catch block
            }
        }
        return prompt;
    }

    private XmlRpcArray runCommand(boolean checkExitValue, String methodName, Object[] params) throws XmlRpcCommandException {
        try {
            XmlRpcArray result = (XmlRpcArray)this.server.getClient(false).invoke(methodName, params);
            if (checkExitValue && result.getInteger(0) != 0 && !"".equals(result.getString(2))) {
                XmlRpcCommandException e = new XmlRpcCommandException(BzrXmlRpcError.fromXml(result.getString(2)));
                e.setStackTrace(XmlRpcCommandException.getCurrentStackTrace());
                throw e;
            }
            return result;
        }
        catch (XmlRpcFault fault) {
            XmlRpcCommandException e = null;
            try {
                e = new XmlRpcCommandException(BzrXmlRpcError.fromXml(fault.getMessage()));
                e.setStackTrace(BazaarClientException.getCurrentStackTrace());
            }
            catch (Exception e1) {
                e = XmlRpcCommandException.wrapException((Exception)((Object)fault));
            }
            throw e;
        }
        catch (MalformedURLException e) {
            throw XmlRpcCommandException.wrapException(e);
        }
    }

    Object executeMethod(String method, XmlRpcArray params) throws XmlRpcCommandException {
        try {
            return this.server.getClient(false).invoke(method, (List)params);
        }
        catch (XmlRpcFault e) {
            throw XmlRpcCommandException.wrapException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw XmlRpcCommandException.wrapException(e);
        }
    }

    @Override
    protected String getSplitExpression() {
        return "\n";
    }

    @Override
    public void runCommand(final Command command, final File workDir) throws BazaarClientException {
        this.result = (XmlRpcArray)new SafeXmlRPCCall<XmlRpcArray>(){

            @Override
            public XmlRpcArray internalExecute() throws XmlRpcCommandException {
                return XMLRPCCommandRunner.this.runCommand(command, command.isCheckExitValue(), workDir);
            }
        }.execute();
    }

    public Object executeMethod(final XmlRpcMethod method) throws BazaarClientException {
        final XmlRpcArray arguments = new XmlRpcArray();
        for (Object arg : method.getArguments()) {
            arguments.add(arg);
        }
        return new SafeXmlRPCCall<Object>(){

            @Override
            public Object internalExecute() throws XmlRpcCommandException {
                return XMLRPCCommandRunner.this.executeMethod(method.getName(), arguments);
            }
        }.execute();
    }

    @Override
    public String getStandardOutput() {
        return this.decodeXMLOutput(this.result.getBinary(1));
    }

    @Override
    public String getStandardOutput(String charsetName) throws UnsupportedEncodingException {
        return new String(this.result.getBinary(1), charsetName);
    }

    @Override
    public String getStandardError() {
        return this.result.getString(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XMLRPCProgressMonitor
    implements Runnable {
        private boolean running;
        private List<String> cmdLine;
        private final IBazaarProgressListener listener;

        public XMLRPCProgressMonitor(List<String> cmdLine, IBazaarProgressListener listener) {
            this.listener = listener;
            this.cmdLine = cmdLine;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.running) continue;
                try {
                    XmlRpcClient client = XMLRPCCommandRunner.this.server.getClient(true);
                    Object[] params = new Object[]{this.cmdLine};
                    String result = (String)client.invoke("get_bzr_progress", params);
                    if (result == null) continue;
                    String progress = result;
                    this.listener.logProgress(progress);
                }
                catch (Exception e) {
                    this.running = false;
                }
            }
        }

        public void start() {
            this.running = true;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }

        public void stop() {
            this.running = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class SafeXmlRPCCall<T> {
        protected SafeXmlRPCCall() {
        }

        public T execute() throws XmlRpcCommandException {
            try {
                return this.internalExecute();
            }
            catch (XmlRpcException e) {
                XMLRPCCommandRunner.this.server.checkStatus();
                try {
                    return this.internalExecute();
                }
                catch (XmlRpcException e1) {
                    throw XmlRpcCommandException.wrapException((Exception)((Object)e1));
                }
            }
        }

        public abstract T internalExecute() throws XmlRpcCommandException;
    }
}

