/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

/**
 * @author Piotr Piastucki
 */
public enum BazaarConflictType {
	PATH_CONFLICT("path conflict"),
	CONTENTS_CONFLICT("contents conflict"),
	TEXT_CONFLICT("text conflict"),
	DUPLICATE_ID("duplicate id"),
	DUPLICATE_ENTRY("duplicate"),
	PARENT_LOOP("parent loop"),
	UNVERSIONED_PARENT("unversioned parent"),
	MISSING_PARENT("missing parent"),
	DELETING_PARENT("deleting parent"),
	NON_DIRECTORY_PARENT("non-directory parent"),
	UNKNOWN("unknown");

	private String type;

	private BazaarConflictType(String type) {
		this.type = type;
	}

	@Override
	public String toString() {
		return type;
	}

	public static BazaarConflictType fromString(String name) {
		for(BazaarConflictType item : BazaarConflictType.values()) {
			if (item.toString().equals(name))
				return item;
		}
		throw new EnumConstantNotPresentException(BazaarConflictType.class, name);
	}
}
