package org.vcs.bazaar.client;


public class BazaarItemInfo implements IBazaarItemInfo {

	private static final long serialVersionUID = 2518314401411409263L;

	private String id;
	private String path;
	private BazaarItemKind kind;
	private BazaarStatusKind statusKind;
	private String pattern;
	private IBazaarLogMessage log;	

	public BazaarItemInfo(BazaarItemKind kind, String id, String path, BazaarStatusKind type, String pattern, IBazaarLogMessage log) {
		this.kind = kind;
		this.id = id;
		this.path = path;
		this.statusKind = type;
		this.pattern = pattern;
		this.log = log;
	}

	public String getId() {
		return id;
	}

	public BazaarItemKind getKind() {
		return kind;
	}

	public String getPath() {
		return path;
	}

	public BazaarStatusKind getStatusKind() {
		return statusKind;
	}

	public String getPattern() {
		return pattern;
	}

	public IBazaarLogMessage getLog() {
		return log;
	}

}
