/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Guillermo Gonzalez
 *
 * TODO: need revision
 */
public class BazaarNotificationHandler {
	protected final List<IBazaarNotifyListener> notifylisteners = new ArrayList<IBazaarNotifyListener>();

	protected int command;

	protected boolean logEnabled = true;
	protected boolean debugEnabled = true;

	/**
	 * Add a notification listener
	 *
	 * @param listener
	 */
	public void add(IBazaarNotifyListener listener) {
		notifylisteners.add(listener);
	}

	/**
	 * Remove a notification listener
	 *
	 * @param listener
	 */
	public void remove(IBazaarNotifyListener listener) {
		notifylisteners.remove(listener);
	}

	/**
	 * restore logging
	 */
	public void enableLog() {
		logEnabled = true;
	}

	/**
	 * disable all logging
	 */
	public void disableLog() {
		logEnabled = false;
	}

	public void logMessage(String message) {
		if (logEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logMessage(message);
			}
		}
	}

	public void logError(String message) {
		if (logEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logError(message);
			}
		}
	}

	public void logRevision(long revision, String path) {
		if (logEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logRevision(revision, path);
			}
		}
	}

	public void logCompleted(String message) {
		if (logEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logCompleted(message);
			}
		}
	}

	/**
	 * set the command
	 *
	 * @param command
	 */
	public void setCommand(int command) {
		this.command = command;
		for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
			IBazaarNotifyListener listener = it.next();
			listener.setCommand(command);
		}
	}

	/**
	 * log the command line
	 *
	 * @param commandLine
	 */
	public void logCommandLine(String commandLine) {
		if (logEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logCommandLine(commandLine);
			}
		}
	}

	public void logCommandOutput(String message) {
		if (logEnabled && debugEnabled) {
			for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
				IBazaarNotifyListener listener = it.next();
				listener.logCommandOutput(message);
			}
		}
	}

	/**
	 * To call when a method of ClientAdapter throw an exception
	 *
	 * @param clientException
	 */
	public void logException(Exception clientException) {
		if (logEnabled) {
			Throwable e = clientException;
			while (e != null) {
				logError(e.getMessage());
				e = e.getCause();
			}
		}
	}

	public void notifyListenersOfChange(String path) {
		if (path == null)
			return;
		File file = new File(path);
		for (Iterator<IBazaarNotifyListener> it = notifylisteners.iterator(); it.hasNext();) {
			IBazaarNotifyListener listener = it.next();
			listener.onNotify(file);
		}

	}

}
