/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * <p>
 * An abstract class which define some common behaivor for commands who operate
 * over multiple files/directories
 * </p>
 *
 * @author Guillermo Gonzalez
 */
public abstract class MultiFileCommand extends Command {

	protected final File[] resources;

	public MultiFileCommand(File workDir, final File[] files) {
		super(workDir);
		this.resources = files;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.commandline.internal.Command#execute()
	 */
	@Override
	public void execute(CommandRunner runner) throws BazaarClientException {
		if (shouldExecute()) {
			super.execute(runner);
		}
	}

	protected boolean shouldExecute() {
		return resources.length > 0;
	}
	
	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {

		List<String> args = new ArrayList<String>();
		for(File f : resources) {
			args.add(getRelativeToWorkDir(f).getPath());
		}

		return args;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.model.ICommand#getEstimatedWork()
	 */
	public int getEstimatedWork() {
		return this.resources.length;
	}

}
