package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.core.BranchLocation;

public abstract class SingleFileOrLocationCommand extends SingleFileCommand {

	private String location;

	public SingleFileOrLocationCommand(final File workDir, final File resource) {
		super(workDir, resource);
	}

	public SingleFileOrLocationCommand(final File workDir, final URI location) {
		super(workDir);
		this.location = location.toString();
	}

	public SingleFileOrLocationCommand(final File workDir, final BranchLocation location) {
		super(workDir);
		this.location = location.toString();
	}

	protected List<String> getArguments() {
		List<String> args = new ArrayList<String>();
		if (file != null) {
			args.add(getRelativeToWorkDir(file).getPath());
		} else {
			args.add(location);
		}
		return args;
	}

}
