/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.syntax.IWhoamiOptions;

/**
 * @author Piotr Piastucki
 */
public class Whoami extends Command implements IWhoamiOptions {

	private String name;

	public Whoami(final File workDir, String name) {
		super(workDir);
		this.name = name;
	}
	
	public Whoami(final File workDir) {
		super(workDir);
	}

	@Override
	public String getCommand() {
		return IWhoamiOptions.COMMAND;
	}

	@Override
	protected List<String> getArguments() throws CommandLineException {
		return getArguments(name);
	}

	public void setEnviroment(ProcessBuilder pb) {
		/* BZR_EMAIL variable needs to be removed otherwise it will override any value whoami command might return */
		pb.environment().remove(BazaarPreference.BZR_EMAIL.name());
	}
}
