/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarTag;
import org.vcs.bazaar.client.IBazaarTag;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/**
 * @author Piotr Piastucki
 */
public class XMLTagsParser extends XMLParser {

	private static final String TAGS = "tags";
	private static final String TAG = "tag";
	private static final String NAME = "name";
	private final static String REVISION = "revision";

	public static List<IBazaarTag> parse(String xml) throws BazaarClientException {
		KXmlParser parser = new KXmlParser();
		try {
			parser.setInput(new StringReader(xml));
			return new XMLTagsParser().parse(parser);
		} catch (XmlPullParserException e) {
			throw BazaarClientException.wrapException(e);
		}
	}

	public List<IBazaarTag> parse(KXmlParser aParser) throws BazaarClientException {
		List<IBazaarTag> tags = new ArrayList<IBazaarTag>();
		parser = aParser;
		try {
			parser.nextTag();
			parser.require(KXmlParser.START_TAG, null, TAGS);
			int eventType = parser.getEventType();
			while (eventType != XmlPullParser.END_DOCUMENT
					&& !(eventType == XmlPullParser.END_TAG && TAGS.equals(parser.getName()))) {
				if (eventType == XmlPullParser.START_TAG && TAG.equals(parser.getName())) {
					IBazaarTag tag = parseTag();
					if (tag != null) {
						tags.add(tag);
					}
				}
				eventType = parser.next();
			}
			return tags;
		} catch (XmlPullParserException e) {
			throw BazaarClientException.wrapException(e);
		} catch (IOException e) {
			throw BazaarClientException.wrapException(e);
		}
	}

	private IBazaarTag parseTag() throws XmlPullParserException, IOException {
		String name = null;
		String revno = null;
		int eventType = parser.next();
		while (eventType != XmlPullParser.END_DOCUMENT
				&& !(eventType == XmlPullParser.END_TAG && TAG.equals(parser.getName()))) {
			if (eventType == XmlPullParser.START_TAG && NAME.equals(parser.getName())) {
				name = parser.nextText();
			} else if (eventType == XmlPullParser.START_TAG && REVISION.equals(parser.getName())) {
				revno = parser.nextText();
				if ("?".equals(revno)) {
					revno = null;
				}
			}
			eventType = parser.next();
		}
		return new BazaarTag(name, revno);
	}

}
