/**
 *
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.StringReader;

import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarVersion;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StringUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/**
 * @author Guillermo Gonzalez <guillo.gonzo@gmail.com>
 *
 */
public class XMLVersionParser extends XMLParser {

    private static final String BAZAAR = "bazaar";
    private static final String VERSION = "version";
    private static final String BZRLIB = "bzrlib";
    private final static String CONFIGURATION = "configuration";
    private final static String LOG_FILE = "log_file";
    private final static String COPYRIGHT = "copyright";
    // TODO: read the python section, and support bzr.exe
    //private static final String PYTHON = "python";
    //private static final String EXECUTABLE = "executable";
    //private static final String STD_LIB = "standard_library";

    public static BazaarVersion parse(String xml) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        String version = null;
        String bzrlib = null;
        String configuration = null;
        String logFile = null;
        String copyright = null;
        try {
            parser.setInput(new StringReader(xml));
            parser.nextTag();
            parser.require(KXmlParser.START_TAG, null, VERSION);
            parser.nextTag();
            parser.require(KXmlParser.START_TAG, null, BAZAAR);
            int eventType = parser.getEventType();
            while (eventType != XmlPullParser.END_DOCUMENT || (eventType == XmlPullParser.END_TAG && BAZAAR.equals(parser.getName()))) {
                if (eventType == XmlPullParser.START_TAG && VERSION.equals(parser.getName())) {
                    version = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == XmlPullParser.START_TAG && BZRLIB.equals(parser.getName())) {
                    bzrlib = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == XmlPullParser.START_TAG && CONFIGURATION.equals(parser.getName())) {
                    configuration = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == XmlPullParser.START_TAG && LOG_FILE.equals(parser.getName())) {
                    logFile = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == XmlPullParser.START_TAG && COPYRIGHT.equals(parser.getName())) {
                    copyright = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == XmlPullParser.END_TAG && BAZAAR.equals( parser.getName() )) {
                    break;
                }
                eventType = parser.next();
            }
            return new BazaarVersion(version, bzrlib, configuration, logFile, copyright);
        } catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException(e);
        } catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
    }
}
