/**
 *
 */
package org.vcs.bazaar.client.xmlrpc;

import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.commandline.CommandLineClient;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCCommandRunner;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCServer;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class XmlRpcClient extends CommandLineClient {

	private final XMLRPCServer server;

	public XmlRpcClient(final CommandLineNotificationHandler notificationHandler) {
		super(notificationHandler);
		server = XMLRPCServer.getInstance(BazaarClientPreferences.getInstance());
	}

	@Override
	protected CommandRunner getCommandRunner() {
		return new XMLRPCCommandRunner(server);
	}
	
	public void execute(Command command) throws BazaarClientException {
		this.run(command);
	}

	public Object execute(XmlRpcMethod method) throws BazaarClientException {
		return ((XMLRPCCommandRunner)getCommandRunner()).executeMethod(method);
	}

	public void stopXmlRpcService() throws BazaarClientException {
		server.shutdown(true);
	}

}
