/**
 *
 */
package org.vcs.bazaar.client.xmlrpc.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.xmlrpc.BzrXmlRpcError;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class XMLErrorParser extends XMLParser {

	private static final Log LOG = LogFactory.getLog(XMLErrorParser.class);

	private static final String ERROR = "error";
	private static final String CLASS = "class";
	private static final String DICT = "dict";
	private static final String DICT_KEY = "key";
	private static final String DICT_VALUE = "value";
	private static final String MESSAGE = "message";

	public XMLErrorParser() {
		super();
		parser = new KXmlParser();
	}

	@SuppressWarnings("unchecked")
    public IBzrError parse(String xml)  {
		try {
			parser.setInput(new StringReader(xml));
			int eventType = parser.getEventType();
			while (eventType != XmlPullParser.END_DOCUMENT) {
				if(eventType == XmlPullParser.START_TAG && ERROR.equals(parser.getName())) {
					return parseError();
				}
				eventType = parser.next();
			}
		} catch (XmlPullParserException e) {
			LOG.error("Trouble while parsing error", e);
		} catch (IOException e) {
			LOG.error("IO trouble while parsing error", e);
		}
		return new BzrXmlRpcError(Collections.EMPTY_MAP, xml, "unknown");
	}

	private IBzrError parseError() throws XmlPullParserException, IOException {
		String type = null;
		String message = null;
		Map<String, String> dict = null;

		int eventType = parser.getEventType();
		do {
			switch(eventType) {
			case XmlPullParser.START_TAG:
				if(CLASS.equals(parser.getName())) {
					type = parser.nextText();
				}
				if(MESSAGE.equals(parser.getName())) {
					message = parser.nextText();
				}
				if(DICT.equals(parser.getName())) {
					dict = parseDict();
				}
				break;
			}
		} while (!(isEndTag(eventType = parser.next()) && ERROR.equals(parser.getName())));

		return new BzrXmlRpcError(dict, message, type);

	}

	private Map<String, String> parseDict() throws XmlPullParserException, IOException {
		int eventType = parser.nextTag();
		Map<String, String> dict = new HashMap<String, String>(0);
		while (!(isEndTag(eventType) && DICT.equals(parser.getName()))){
			String key = null;
			String value = null;
			parser.require(KXmlParser.START_TAG, null, DICT_KEY);
			key = parser.nextText();
			eventType = parser.nextTag();
			parser.require(KXmlParser.START_TAG, null, DICT_VALUE);
			value = parser.nextText();
			eventType = parser.nextTag();
			dict.put(key, value);
		}
		return dict;
	}
}
