package org.vcs.bazaar.client;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarRevision.Prefix;

public class BazaarRevisionTest {

	@Test
	public void testCompareTo() {
		BazaarRevision rev1 = BazaarRevision.getRevision(Prefix.REVNO, "270");
		BazaarRevision rev2 = BazaarRevision.getRevision(Prefix.REVNO, "270");
		Assert.assertEquals(0, rev1.compareTo(rev2));

		rev1 = BazaarRevision.getRevision(Prefix.REVNO, "269");
		rev2 = BazaarRevision.getRevision(Prefix.REVNO, "270");
		Assert.assertEquals(-1, rev1.compareTo(rev2));
		Assert.assertEquals(1, rev2.compareTo(rev1));

		rev1 = BazaarRevision.getRevision(Prefix.REVNO, "269.1.2");
		rev2 = BazaarRevision.getRevision(Prefix.REVNO, "269.1.3.1");
		Assert.assertEquals(-1, rev1.compareTo(rev2));
		Assert.assertEquals(1, rev2.compareTo(rev1));

		rev1 = BazaarRevision.getRevision(Prefix.REVNO, "269.1.2.0");
		rev2 = BazaarRevision.getRevision(Prefix.REVNO, "269.1.3");
		Assert.assertEquals(-1, rev1.compareTo(rev2));
		Assert.assertEquals(1, rev2.compareTo(rev1));

	}
}
