/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import java.io.File;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.commandline.syntax.ICleanTreeOptions;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

/**
 * @author Piotr Piastucki
 */
public class CleanTreeTest extends BazaarTest {

	@Test public final void testCleanTree() throws Exception {
		Environment testEnv = new Environment("clean-tree", getTestConfig());
		client.setWorkDir(testEnv.getWorkingTreeLocation());
		File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root_new.txt");
		File fileInA = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A_new");
		fileInRoot.createNewFile();
		fileInA.createNewFile();
		String[] unknowns = client.unknowns(testEnv.getWorkingTreeLocation());
		Assert.assertEquals("Unknown files", 2, unknowns.length);
		client.cleanTree(ICleanTreeOptions.FORCE);
		unknowns = client.unknowns(testEnv.getWorkingTreeLocation());
		Assert.assertEquals("Unknown files", 0, unknowns.length);
	}
	
}
