/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import static org.vcs.bazaar.client.testUtils.FileUtils.assertWTEqual;

import java.io.File;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.commandline.syntax.IReconfigureOptions;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

/**
 * @author Piotr Piastucki
 */
public class ReconfigureTest extends BazaarTest {

	@Test public final void testReconfigure() throws Exception {
		Environment testEnv = new Environment("reconfigure-tree", getTestConfig());
		File checkout = new File(testEnv.getWorkingTreeLocation().getParent(), "checkout");
		client.setWorkDir(checkout.getParentFile());
		client.checkout(new BranchLocation(testEnv.getWorkingTreeLocation().toURI()), checkout);
		assertWTEqual(testEnv.getWorkingTreeLocation(), checkout);
		IBazaarInfo info = client.info(checkout);
		Assert.assertEquals("Checkout", info.getLayout());
		client.reconfigure(new BranchLocation(checkout.toURI()), null, IReconfigureOptions.BRANCH);
		info = client.info(checkout);
		Assert.assertEquals("Standalone branch", info.getLayout());
		client.reconfigure(new BranchLocation(checkout.toURI()), null, IReconfigureOptions.CHECKOUT);
		info = client.info(checkout);
		Assert.assertEquals("Checkout", info.getLayout());
	}
	
}
