/**
 *
 */
package org.vcs.bazaar.client.commandline.commands;

import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.ShellCommandRunner;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.testUtils.BazaarTest;

/**
 * Tests for {@link Plugins} command,
 *
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 */
public class PluginsTest extends BazaarTest {

    /**
     * Tests the plugins command with an empty BZR_PLUGINS_PATH
     * @throws Exception
     */
    @Test
    public final void testBadPluginsPath() throws Exception {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        String old = prefs.getString(BazaarPreference.BZR_PLUGIN_PATH);
        prefs.set(BazaarPreference.BZR_PLUGIN_PATH, "foo/bar");
        Plugins cmd = new Plugins();
        try {
            cmd.execute(new ShellCommandRunner());
        } catch(CommandLineException e) {
            Assert.assertEquals("xmlplugins", e.getCommand());
        } finally {
            prefs.set(BazaarPreference.BZR_PLUGIN_PATH, old);
        }
    }

    @Test
    public final void testDefaultPluginsPath() throws Exception {
        Plugins cmd = new Plugins();
        cmd.execute(new ShellCommandRunner());
        Set<IPlugin> plugins = new XMLPluginParser().parse(cmd.getStandardOutput());
        Assert.assertTrue(cmd.getStandardOutput().contains("xmloutput"));
        for (IPlugin plugin : plugins) {
            if(plugin.getName().equals("xmloutput")){
                return;
            }
        }
        Assert.fail("xmloutput plugin not found");
    }

}
