/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;
/**
 * @author Piotr Piastucki
 */
public class XMLShelveListParserTest extends ParserTest {

	@Test
	public void testShelves() throws ParseException, BazaarClientException, IOException {

		List<IBazaarShelf> shelves = XMLShelveListParser.parse(getContentsFrom(shelvesFile));

		Assert.assertNotNull(shelves);
		Assert.assertEquals(4, shelves.size());
		
		Assert.assertEquals("1", shelves.get(0).getId());
		Assert.assertEquals("Shelf #1 message", shelves.get(0).getMessage());
		Assert.assertEquals("2", shelves.get(1).getId());
		Assert.assertEquals("Shelf #2 message", shelves.get(1).getMessage());
		Assert.assertEquals("3", shelves.get(2).getId());
		Assert.assertEquals("Shelf #3 message", shelves.get(2).getMessage());
		Assert.assertEquals("4", shelves.get(3).getId());
		Assert.assertEquals("Shelf #4 message", shelves.get(3).getMessage());
	}
}
