package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarTag;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLTagsParserTest extends ParserTest {

	@Test
	public void testTags() throws ParseException, BazaarClientException, IOException {

		List<IBazaarTag> tags = XMLTagsParser.parse(getContentsFrom(tagsFile));

		Assert.assertNotNull(tags);
		Assert.assertEquals(6, tags.size());
		
		Assert.assertEquals("tag_0_1", tags.get(0).getName());
		Assert.assertEquals(BazaarRevision.getRevision(10), tags.get(0).getRevision());
		Assert.assertEquals("tag_0_2", tags.get(1).getName());
		Assert.assertEquals(BazaarRevision.getRevision(8), tags.get(1).getRevision());
		Assert.assertEquals("tag_0_3", tags.get(2).getName());
		Assert.assertEquals(BazaarRevision.getRevision(6), tags.get(2).getRevision());
		Assert.assertEquals("tag_0_4", tags.get(3).getName());
		Assert.assertEquals(BazaarRevision.getRevision(4), tags.get(3).getRevision());
		Assert.assertEquals("tag_0_5", tags.get(4).getName());
		Assert.assertEquals(null, tags.get(4).getRevision());
		Assert.assertEquals("tag_0_6", tags.get(5).getName());
		Assert.assertEquals(BazaarRevision.getRevision(1), tags.get(5).getRevision());
}
}
