/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.testUtils;

import java.io.File;
import java.io.IOException;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 */

public abstract class BazaarTest {

	protected IBazaarClient client;
	protected static TestsConfig testsConfig;
	private TestConfig testConfig = null;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();

        if (System.getenv("BZR_PLUGIN_PATH") != null) {
            System.out.println("Using Bazaar plugins directory from environment:");
            System.out.println("  BZR_PLUGIN_PATH = " + System.getenv("BZR_PLUGIN_PATH")); 
        } else {
            // Set the Bazaar plugins directory to use.  A directory in the current
            // project is preferred, to support development versions of
            // bzr-xmloutput, otherwise fall back to the standard directory.
            String currentdir = System.getProperty("user.dir");
            String[] tryDirs = {currentdir + File.separator + "bzr-java-lib",
                                currentdir};
            boolean found = false;
            for (String tryDir: tryDirs) {
                tryDir = tryDir + File.separator + "bazaar-plugins";
                if (new File(tryDir).exists()) {
                    System.out.println("Using Bazaar plugins directory: " + tryDir);
                    prefs.set(BazaarPreference.BZR_PLUGIN_PATH, tryDir);
                    found = true;
                    break;
                }
            }
            if (!found) {
                System.out.println("Using default Bazaar plugins directory");
            }
        }

		testsConfig = TestsConfig.getTestsConfig();
		testsConfig.createWorkingTree();
	}

	@Before
	public void setUp() {
		// get the client
		client = testsConfig.client;
		client.setWorkDir(testsConfig.rootDir);
	}

	/*
	 * Note: This method use init, add and commit.
	 *
	 */
	public TestConfig getTestConfig() throws IOException, BazaarClientException {
		if (testConfig == null) {
			testConfig = new TestConfig(client, testsConfig.defaultWorkingTreeLocation, testsConfig.defaultWorkingTree);
		}
		return testConfig;
	}

	protected static String getUserName() {
		return TestsConfig.getUserName();
	}

	protected static String getBzrMail() {
		return TestsConfig.getBzrMail();
	}

	@AfterClass
	public static void tearDownAfterClass() {
		if(testsConfig != null) {
			testsConfig.deleteWorkingTree();
		}
	}
}
