/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.utils;

import java.io.File;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class BazaarUtilitiesTestWithBranch extends BazaarTest {

	@Test public void testGetRelativeTo() throws Exception {
		Environment testEnv;
		testEnv = new Environment("getRelativeToTest", getTestConfig());
		client.setWorkDir(testEnv.getWorkingTreeLocation());

		File newDir = new File(testEnv.getWorkingTreeLocation(), "new_Dir");
		newDir.mkdirs();
			Assert.assertEquals(testEnv.getWorkingTreeLocation(), BazaarUtilities.getRootBranch(newDir));
	}

	@Test public void testGetRootBranch() throws Exception {
		Environment testEnv;
		testEnv = new Environment("getRelativeToTest", getTestConfig());
		client.setWorkDir(testEnv.getWorkingTreeLocation());

		File newDir = new File(testEnv.getWorkingTreeLocation(), "new_Dir");
		newDir.mkdirs();
		Assert.assertEquals(testEnv.getWorkingTreeLocation(), BazaarUtilities.getRootBranch(newDir));
	}

}
