/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarConflictType;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.commandline.parser.XMLConflictsParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLConflictsParserTest
extends ParserTest {
    @Test
    public void testTags() throws ParseException, BazaarClientException, IOException {
        List conflicts = XMLConflictsParser.parse((String)XMLConflictsParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/conflicts.xml"));
        Assert.assertNotNull((Object)conflicts);
        Assert.assertEquals((long)5L, (long)conflicts.size());
        Assert.assertEquals((Object)BazaarConflictType.CONTENTS_CONFLICT, (Object)((IBazaarConflict)conflicts.get(0)).getType());
        Assert.assertEquals((Object)"content-conflict", (Object)((IBazaarConflict)conflicts.get(0)).getPath());
        Assert.assertEquals((Object)"Contents conflict in content-conflict", (Object)((IBazaarConflict)conflicts.get(0)).getMessage());
        Assert.assertEquals((Object)BazaarConflictType.TEXT_CONFLICT, (Object)((IBazaarConflict)conflicts.get(1)).getType());
        Assert.assertEquals((Object)"dir/file", (Object)((IBazaarConflict)conflicts.get(1)).getPath());
        Assert.assertEquals((Object)"Text conflict in dir/file", (Object)((IBazaarConflict)conflicts.get(1)).getMessage());
        Assert.assertEquals((Object)BazaarConflictType.DUPLICATE_ENTRY, (Object)((IBazaarConflict)conflicts.get(2)).getType());
        Assert.assertEquals((Object)"duplicate-conflict.moved", (Object)((IBazaarConflict)conflicts.get(2)).getPath());
        Assert.assertEquals((Object)"Conflict adding file duplicate-conflict.  Moved existing file to duplicate-conflict.moved.", (Object)((IBazaarConflict)conflicts.get(2)).getMessage());
        Assert.assertEquals((Object)BazaarConflictType.TEXT_CONFLICT, (Object)((IBazaarConflict)conflicts.get(3)).getType());
        Assert.assertEquals((Object)"file", (Object)((IBazaarConflict)conflicts.get(3)).getPath());
        Assert.assertEquals((Object)"Text conflict in file", (Object)((IBazaarConflict)conflicts.get(3)).getMessage());
        Assert.assertEquals((Object)BazaarConflictType.PATH_CONFLICT, (Object)((IBazaarConflict)conflicts.get(4)).getType());
        Assert.assertEquals((Object)"path-conflict-new", (Object)((IBazaarConflict)conflicts.get(4)).getPath());
        Assert.assertEquals((Object)"Path conflict: path-conflict-new / <deleted>", (Object)((IBazaarConflict)conflicts.get(4)).getMessage());
    }
}

