/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.parser.XMLLogParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLogParserTest
extends ParserTest {
    List<IBazaarLogMessage> logs;
    List<IBazaarLogMessage> logsWithId;

    @Before
    public void loadLogs() throws BazaarClientException, IOException {
        this.logs = XMLLogParser.parse((String)XMLLogParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/log.xml"));
        Assert.assertNotNull(this.logs);
        Assert.assertFalse((this.logs.size() == 0 ? 1 : 0) != 0);
        this.logsWithId = XMLLogParser.parse((String)XMLLogParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/log_showids.xml"));
        Assert.assertNotNull(this.logsWithId);
        Assert.assertFalse((this.logsWithId.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleLog() {
        Assert.assertEquals((String)"Number of log message diffier", (long)6L, (long)this.logs.size());
        int counter = 0;
        for (IBazaarLogMessage log : this.logs) {
            ++counter;
            if (log.getMerged() == null || log.getMerged().size() <= 0) continue;
            counter += log.getMerged().size();
        }
        Assert.assertEquals((String)"Number of TOTAL log messages diffier", (long)21L, (long)counter);
        Assert.assertEquals((String)"Number of affected files in the first log", (long)2L, (long)this.logs.get(0).getAffectedFiles().size());
        IBazaarLogMessage fifthLog = this.logs.get(4);
        Assert.assertEquals((String)"Number of affected files at the 5th log ", (long)3L, (long)fifthLog.getAffectedFiles().size());
        IBazaarLogMessage fifthLogFirstChild = (IBazaarLogMessage)fifthLog.getMerged().get(0);
        for (int i = 0; i < fifthLogFirstChild.getAffectedFiles().size(); ++i) {
            if (i == 0) {
                ((IBazaarStatus)fifthLogFirstChild.getAffectedFiles().get(i)).contains(BazaarStatusKind.CREATED);
                continue;
            }
            ((IBazaarStatus)fifthLogFirstChild.getAffectedFiles().get(i)).contains(BazaarStatusKind.MODIFIED);
        }
        Assert.assertEquals((String)"Number of affected files in first merge log at the 5th log ", (long)33L, (long)((IBazaarLogMessage)this.logs.get(4).getMerged().get(0)).getAffectedFiles().size());
    }

    private void sortStatuses(List<IBazaarStatus> unsorted) {
        Collections.sort(unsorted, new Comparator<IBazaarStatus>(){

            @Override
            public int compare(IBazaarStatus o1, IBazaarStatus o2) {
                return o1.getPath().compareToIgnoreCase(o2.getPath());
            }
        });
    }

    @Test
    public void testAffectedFiles() {
        int i;
        IBazaarLogMessage firstLog = this.logs.get(0);
        ArrayList<IBazaarStatus> files = new ArrayList<IBazaarStatus>();
        files.addAll(firstLog.getAffectedFiles());
        this.sortStatuses(files);
        String[] expected = new String[]{"bzrlib/errors.py", "NEWS"};
        Assert.assertEquals((long)expected.length, (long)files.size());
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)((IBazaarStatus)files.get(i)).getPath());
        }
        files.clear();
        files.addAll(firstLog.getAffectedFiles(true));
        this.sortStatuses(files);
        expected = new String[]{"bzrlib/errors.py", "NEWS"};
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)((IBazaarStatus)files.get(i)).getPath());
        }
    }

    @Test
    public void testParents() {
        IBazaarLogMessage firstLog = this.logsWithId.get(0);
        Assert.assertEquals((long)1L, (long)firstLog.getParents().size());
        IBazaarLogMessage aLog = this.logsWithId.get(7);
        Assert.assertEquals((long)2L, (long)aLog.getParents().size());
    }

    @Test
    public void testRevisionId() {
        IBazaarLogMessage firstLog = this.logsWithId.get(0);
        Assert.assertEquals((Object)"guillo.gonzo@gmail.com-20080824030806-cqf1nsf47bgp2bwr", (Object)firstLog.getRevisionId());
    }

    @Test
    public void testTags() {
        IBazaarLogMessage firstLog = this.logs.get(0);
        Assert.assertEquals((long)0L, (long)firstLog.getTags().size());
        IBazaarLogMessage aLog = this.logs.get(1);
        Assert.assertEquals((long)2L, (long)aLog.getTags().size());
    }
}

