/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.testUtils;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.TestConfig;
import org.vcs.bazaar.client.testUtils.TestsConfig;

public abstract class BazaarTest {
    protected IBazaarClient client;
    protected static TestsConfig testsConfig;
    private TestConfig testConfig = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        if (System.getenv("BZR_PLUGIN_PATH") != null) {
            System.out.println("Using Bazaar plugins directory from environment:");
            System.out.println("  BZR_PLUGIN_PATH = " + System.getenv("BZR_PLUGIN_PATH"));
        } else {
            String currentdir = System.getProperty("user.dir");
            String[] tryDirs = new String[]{currentdir + File.separator + "bzr-java-lib", currentdir};
            boolean found = false;
            for (String tryDir : tryDirs) {
                if (!new File(tryDir = tryDir + File.separator + "bazaar-plugins").exists()) continue;
                System.out.println("Using Bazaar plugins directory: " + tryDir);
                prefs.set(BazaarPreference.BZR_PLUGIN_PATH, tryDir);
                found = true;
                break;
            }
            if (!found) {
                System.out.println("Using default Bazaar plugins directory");
            }
        }
        testsConfig = TestsConfig.getTestsConfig();
        testsConfig.createWorkingTree();
    }

    @Before
    public void setUp() {
        this.client = BazaarTest.testsConfig.client;
        this.client.setWorkDir(BazaarTest.testsConfig.rootDir);
    }

    public TestConfig getTestConfig() throws IOException, BazaarClientException {
        if (this.testConfig == null) {
            this.testConfig = new TestConfig(this.client, BazaarTest.testsConfig.defaultWorkingTreeLocation, BazaarTest.testsConfig.defaultWorkingTree);
        }
        return this.testConfig;
    }

    protected static String getUserName() {
        return TestsConfig.getUserName();
    }

    protected static String getBzrMail() {
        return TestsConfig.getBzrMail();
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (testsConfig != null) {
            testsConfig.deleteWorkingTree();
        }
    }
}

