/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.utils.BazaarUtilities;

public class BazaarUtilitiesTest {
    @Test
    public void testGetRelativeUnix() {
        File base = new File("/home/user/bzr/project/trunk");
        File file = new File("/home/user/bzr/project/trunk/src_folder/file");
        File relative = BazaarUtilities.getRelativeTo((File)base, (File)file);
        Assert.assertEquals((Object)new File("src_folder/file"), (Object)relative);
    }

    @Test
    public void testGetRelativeWindows() {
        File base = new File("c:\\bzr\\project\\trunk");
        File file = new File("c:\\bzr\\project\\trunk\\src_folder\\file");
        File relative = BazaarUtilities.getRelativeTo((File)base, (File)file);
        if (File.separatorChar == '\\') {
            Assert.assertEquals((Object)new File("src_folder\\file"), (Object)relative);
        } else {
            Assert.assertEquals((Object)new File("src_folder/file"), (Object)relative);
        }
    }

    @Test
    public void testUriEscapesMetaChar() {
        File base = new File("/home/file%07with%08funkyescapes");
        String uri = base.toURI().toString();
        Assert.assertEquals((Object)"file%2507with%2508funkyescapes", (Object)uri.substring(uri.lastIndexOf(47) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWindowsExecutable() throws IOException {
        File bat = File.createTempFile("bzr-eclipse", ".bat");
        try {
            FileWriter fw = new FileWriter(bat);
            fw.append("@C:\\\\Python25\\\\python.exe C:\\\\Python25\\\\Scripts\\\\bzr %*");
            fw.close();
            List exe = BazaarUtilities.getWindowsExecutable((String)bat.getAbsolutePath());
            Object[] expected = new String[]{"C:\\\\Python25\\\\python.exe", "C:\\\\Python25\\\\Scripts\\\\bzr"};
            Assert.assertArrayEquals((Object[])expected, (Object[])exe.toArray(new String[0]));
        }
        finally {
            bat.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindExecutable() throws IOException {
        String sysPath = System.getenv("PATH");
        File tmpFile = File.createTempFile("bzr-eclipse", "");
        tmpFile.delete();
        tmpFile.mkdirs();
        sysPath = tmpFile + File.pathSeparator + sysPath;
        File fakeBzr = new File(tmpFile, "bzr");
        if (BazaarUtilities.isWindows()) {
            fakeBzr = new File(tmpFile, "bzr.exe");
        }
        try {
            fakeBzr.createNewFile();
            Assert.assertEquals((Object)fakeBzr, (Object)BazaarUtilities.findExecutable((String)sysPath));
            if (BazaarUtilities.isWindows()) {
                fakeBzr.delete();
                fakeBzr = new File(tmpFile, "bzr.bat");
                fakeBzr.createNewFile();
                Assert.assertEquals((Object)fakeBzr, (Object)BazaarUtilities.findExecutable((String)sysPath));
            }
        }
        finally {
            fakeBzr.delete();
            tmpFile.delete();
        }
    }
}

