/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.commandline.syntax.IWhoamiOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

/**
 * @author Piotr Piastucki
 */
public class WhoamiTest extends BazaarTest {

	@Test public final void testWhoami() throws Exception {
		Environment testEnv = new Environment("whoami", getTestConfig());
		client.setWorkDir(testEnv.getWorkingTreeLocation());
		String name1;
		try {
			name1 = client.whoami();
		} catch (BazaarClientException e) {
			if (e.getMessage().contains("Unable to determine your name")) {
				client.whoami("TestUser <test@test.com>");
			}
		}
		name1 = client.whoami();
		client.whoami("WhoamiTestName <whoami@test.com>", IWhoamiOptions.BRANCH);
		String name2 = client.whoami();
		Assert.assertEquals("WhoamiTestName <whoami@test.com>", name2);
		client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
		String name3= client.whoami();
		Assert.assertEquals(name1, name3);
		client.setWorkDir(testEnv.getWorkingTreeLocation());
		client.whoami(name1, IWhoamiOptions.BRANCH);
		String name4 = client.whoami();
		Assert.assertEquals(name1, name4);
	}

}
