/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarConflictType;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

/**
 * @author Piotr Piastucki
 */
public class XMLConflictsParserTest extends ParserTest {

	@Test
	public void testTags() throws ParseException, BazaarClientException, IOException {

		List<IBazaarConflict> conflicts = XMLConflictsParser.parse(getContentsFrom(conflictsFile));

		Assert.assertNotNull(conflicts);
		Assert.assertEquals(5, conflicts.size());
		
		Assert.assertEquals(BazaarConflictType.CONTENTS_CONFLICT, conflicts.get(0).getType());
		Assert.assertEquals("content-conflict", conflicts.get(0).getPath());
		Assert.assertEquals("Contents conflict in content-conflict", conflicts.get(0).getMessage());
		Assert.assertEquals(BazaarConflictType.TEXT_CONFLICT, conflicts.get(1).getType());
		Assert.assertEquals("dir/file", conflicts.get(1).getPath());
		Assert.assertEquals("Text conflict in dir/file", conflicts.get(1).getMessage());
		Assert.assertEquals(BazaarConflictType.DUPLICATE_ENTRY, conflicts.get(2).getType());
		Assert.assertEquals("duplicate-conflict.moved", conflicts.get(2).getPath());
		Assert.assertEquals("Conflict adding file duplicate-conflict.  Moved existing file to duplicate-conflict.moved.", conflicts.get(2).getMessage());
		Assert.assertEquals(BazaarConflictType.TEXT_CONFLICT, conflicts.get(3).getType());
		Assert.assertEquals("file", conflicts.get(3).getPath());
		Assert.assertEquals("Text conflict in file", conflicts.get(3).getMessage());
		Assert.assertEquals(BazaarConflictType.PATH_CONFLICT, conflicts.get(4).getType());
		Assert.assertEquals("path-conflict-new", conflicts.get(4).getPath());
		Assert.assertEquals("Path conflict: path-conflict-new / <deleted>", conflicts.get(4).getMessage());
	}
}
