/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarItemKind;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

/**
 * @author Guillermo Gonzalez
 */
public class XMLLsParserTest extends ParserTest {

	@Test public void testparse() throws BazaarClientException, IOException {
		List<IBazaarItemInfo> items = XMLLsParser.parse(getContentsFrom(lsFile));

		Assert.assertNotNull(items);
		Assert.assertFalse(items.size() == 0);
		Assert.assertEquals("Number of items", 45, items.size());
		int fileCounter = 0;
		int dirCounter = 0;
		int symlinkCounter = 0;
		for (IBazaarItemInfo item : items) {
			fileCounter += BazaarItemKind.FILE.equals(item.getKind())?1:0;
			dirCounter += BazaarItemKind.DIRECTORY.equals(item.getKind())?1:0;
			symlinkCounter += BazaarItemKind.SYMLINK.equals(item.getKind())?1:0;
		}
		Assert.assertEquals("Number of files", 44, fileCounter);
		Assert.assertEquals("Number of directories", 1, dirCounter);
		Assert.assertEquals("Number of symlinks", 0, symlinkCounter);

		int versionedCounter = 0;
		int ignoredCounter = 0;
		int unknownCounter = 0;
		for (IBazaarItemInfo item : items) {
			versionedCounter += BazaarStatusKind.VERSIONED.equals(item.getStatusKind())?1:0;
			ignoredCounter += BazaarStatusKind.IGNORED.equals(item.getStatusKind())?1:0;
			unknownCounter += BazaarStatusKind.UNKNOWN.equals(item.getStatusKind())?1:0;
		}
		Assert.assertEquals("Number of versioned items", 21, versionedCounter);
		Assert.assertEquals("Number of ignored items", 19, ignoredCounter);
		Assert.assertEquals("Number of unknown items", 5, unknownCounter);
	}

	@Test public void testParseWithLog() throws BazaarClientException, IOException {
		List<IBazaarItemInfo> items = XMLLsParser.parse(getContentsFrom(lsFileWithLog));
		Set<String> revisions = new HashSet<String>();
		Set<String> committers = new HashSet<String>();
		Assert.assertNotNull(items);
		Assert.assertFalse(items.size() == 0);
		Assert.assertEquals("Incorrect number of items", 21, items.size());
		int fileCounter = 0;
		int dirCounter = 0;
		int symlinkCounter = 0;
		for (IBazaarItemInfo item : items) {
			fileCounter += BazaarItemKind.FILE.equals(item.getKind())?1:0;
			dirCounter += BazaarItemKind.DIRECTORY.equals(item.getKind())?1:0;
			symlinkCounter += BazaarItemKind.SYMLINK.equals(item.getKind())?1:0;
		}
		Assert.assertEquals("Number of files", 21, fileCounter);
		Assert.assertEquals("Number of directories", 0, dirCounter);
		Assert.assertEquals("Number of symlinks", 0, symlinkCounter);

		int versionedCounter = 0;
		int ignoredCounter = 0;
		int unknownCounter = 0;
		for (IBazaarItemInfo item : items) {
			versionedCounter += BazaarStatusKind.VERSIONED.equals(item.getStatusKind())?1:0;
			ignoredCounter += BazaarStatusKind.IGNORED.equals(item.getStatusKind())?1:0;
			unknownCounter += BazaarStatusKind.UNKNOWN.equals(item.getStatusKind())?1:0;
		}
		Assert.assertEquals("Number of versioned items", 9, versionedCounter);
		Assert.assertEquals("Number of ignored items", 7, ignoredCounter);
		Assert.assertEquals("Number of unknown items", 5, unknownCounter);

		for (IBazaarItemInfo item : items) {
			if (item.getLog() != null) {
				revisions.add(item.getLog().getRevision().toString());
				committers.add(item.getLog().getCommiter());
			}
		}
		Assert.assertEquals("Number of revisions", 5, revisions.size());
		Assert.assertEquals("Number of committers", 3, committers.size());
		Assert.assertTrue(committers.contains("John"));
	}
}
