/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.testUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @author Guillermo Gonzalez
 *
 */
public abstract class ParserTest {

	protected final static String logFile = "org/vcs/bazaar/client/commandline/parser/log.xml";
	protected final static String logIdsFile = "org/vcs/bazaar/client/commandline/parser/log_showids.xml";
	protected final static String statusFile = "org/vcs/bazaar/client/commandline/parser/status.xml";
	protected final static String statusWithConflictsFile = "org/vcs/bazaar/client/commandline/parser/status_conflicts.xml";
	protected final static String statusWithPendingMergesFile = "org/vcs/bazaar/client/commandline/parser/status_pending_merges.xml";
	protected final static String annotationFile = "org/vcs/bazaar/client/commandline/parser/annotation.xml";
	protected final static String infoFile = "org/vcs/bazaar/client/commandline/parser/info.xml";
	protected final static String missingFile = "org/vcs/bazaar/client/commandline/parser/missing.xml";
	protected final static String pluginsFile = "org/vcs/bazaar/client/commandline/parser/plugins.xml";
	protected final static String pluginsFileNoDoc = "org/vcs/bazaar/client/commandline/parser/plugins_no_doc.xml";
	protected final static String errorFile = "org/vcs/bazaar/client/commandline/parser/error.xml";
	protected final static String lsFile = "org/vcs/bazaar/client/commandline/parser/ls.xml";
	protected final static String versionFile = "org/vcs/bazaar/client/commandline/parser/version.xml";
	protected final static String tagsFile = "org/vcs/bazaar/client/commandline/parser/tags.xml";
	protected final static String shelvesFile = "org/vcs/bazaar/client/commandline/parser/shelves.xml";
	protected final static String conflictsFile = "org/vcs/bazaar/client/commandline/parser/conflicts.xml";
	protected final static String lsFileWithLog = "org/vcs/bazaar/client/commandline/parser/ls_with_log.xml";

	private static BufferedReader getReaderFor(String file) {
		InputStream in = ParserTest.class.getClassLoader().getResourceAsStream(file);
		return new BufferedReader(new InputStreamReader(in));
	}

	protected static String getContentsFrom(String file) throws IOException {
		final BufferedReader reader = getReaderFor(file);
		final StringBuilder contents = new StringBuilder();
		String line = null;
		try {
			while ((line = reader.readLine()) != null) {
				contents.append(line);
				contents.append(System.getProperty("line.separator"));
			}
		} finally {
			if(reader != null)
				reader.close();
		}
		return contents.toString();
	}
}
