/**
 *
 */
package org.vcs.bazaar.client.xmlrpc.parser;

import java.io.IOException;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.testUtils.ParserTest;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class XMLErrorParserTest extends ParserTest {

	@Test
	public void testSingleError() throws IOException {
		XMLErrorParser parser = new XMLErrorParser();
		IBzrError error = parser.parse(getContentsFrom(errorFile));

		Assert.assertNotNull(error);
		Assert.assertNotNull(error.getDict());
		Assert.assertNotNull(error.getMessage());
		Assert.assertNotNull(error.getType());
		Assert.assertFalse("dict is empty", error.getDict().isEmpty());
		Assert.assertEquals("dict does not contain 2 key:value pairs", 2, error.getDict().size());
		Assert.assertFalse("message is empty", error.getMessage().trim().equals(""));
		Assert.assertFalse("type is empty", error.getType().trim().equals(""));
	}
}
