/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

public class FrequentRestartTest
extends BazaarTest {
    @Before
    public void setup() {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        prefs.set(BazaarPreference.BZR_XMLRPC_RESTART_THRESHOLD, "2");
    }

    @After
    public void cleanup() {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        prefs.unset(BazaarPreference.BZR_XMLRPC_RESTART_THRESHOLD);
    }

    @Test
    public final void testRestart() throws Exception {
        Environment testEnv = new Environment("restart", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        for (int i = 0; i < 10; ++i) {
            this.testLog(testEnv);
            this.testNick(testEnv);
            this.testRevno(testEnv);
        }
    }

    @Test
    public final void testMultiThreadRestart() throws Exception {
        final Environment testEnv = new Environment("restart", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        final AtomicBoolean stop = new AtomicBoolean(false);
        final int[] commands = new int[4];
        Arrays.fill(commands, 0);
        final AtomicBoolean error = new AtomicBoolean(false);
        Thread t1 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!stop.get()) {
                    try {
                        FrequentRestartTest.this.testLog(testEnv);
                    }
                    catch (Throwable e) {
                        error.set(true);
                    }
                    finally {
                        commands[0] = commands[0] + 1;
                    }
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!stop.get()) {
                    try {
                        FrequentRestartTest.this.testLog(testEnv);
                    }
                    catch (Throwable e) {
                        error.set(true);
                    }
                    finally {
                        commands[1] = commands[1] + 1;
                    }
                }
            }
        });
        Thread t3 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!stop.get()) {
                    try {
                        FrequentRestartTest.this.testNick(testEnv);
                    }
                    catch (Throwable e) {
                        error.set(true);
                    }
                    finally {
                        commands[2] = commands[2] + 1;
                    }
                }
            }
        });
        Thread t4 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!stop.get()) {
                    try {
                        FrequentRestartTest.this.testRevno(testEnv);
                    }
                    catch (Throwable e) {
                        error.set(true);
                    }
                    finally {
                        commands[3] = commands[3] + 1;
                    }
                }
            }
        });
        t1.start();
        t2.start();
        t3.start();
        t4.start();
        boolean finished = false;
        while (!finished) {
            finished = true;
            for (int i : commands) {
                if (i >= 5) continue;
                finished = false;
                break;
            }
            Thread.sleep(50L);
        }
        stop.set(true);
        t1.join();
        t2.join();
        t3.join();
        t4.join();
        Assert.assertFalse((boolean)error.get());
    }

    private void testRevno(Environment testEnv) throws BazaarClientException {
        BazaarRevision expectedRevision = BazaarRevision.getRevision((int)1);
        testEnv.getExpectedWorkingTree().setItemsRevision(expectedRevision);
        BazaarRevision result = this.client.revno(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((Object)Integer.valueOf(expectedRevision.getValue().trim()), (Object)Integer.valueOf(result.getValue().trim()));
    }

    private void testNick(Environment testEnv) throws BazaarClientException {
        String nick = this.client.nick(null);
        Assert.assertEquals((Object)testEnv.getWorkingTreeLocation().getName().trim(), (Object)nick);
    }

    private void testLog(Environment testEnv) throws BazaarClientException {
        List logMsgs = this.client.log(testEnv.getWorkingTreeLocation(), new Option[0]);
        Assert.assertEquals((long)1L, (long)logMsgs.size());
        for (IBazaarLogMessage message : logMsgs) {
            Assert.assertEquals((Object)"default_branch", (Object)message.getBranchNick());
            Assert.assertEquals((Object)BazaarRevision.getRevision((int)1).getValue(), (Object)message.getRevision().getValue());
            Assert.assertEquals((Object)FrequentRestartTest.getUserName(), (Object)message.getCommiter());
            Assert.assertEquals((Object)"initial import", (Object)message.getMessage().trim());
        }
    }
}

