/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.parser.XMLMissingParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;
import org.vcs.bazaar.client.utils.StringUtil;

public class XMLMissingParserTest
extends ParserTest {
    @Test
    public void testSimpleStatus() throws ParseException, BazaarClientException, IOException {
        Map missing = null;
        XMLMissingParser missingParser = new XMLMissingParser();
        missing = missingParser.parse(XMLMissingParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/missing.xml"));
        Assert.assertNotNull((Object)missing);
        Assert.assertEquals((long)2L, (long)missing.size());
        List other = (List)missing.get("OTHER");
        List mine = (List)missing.get("MINE");
        Assert.assertNotNull((Object)mine);
        Assert.assertEquals((String)"extra revisions size diffier: ", (long)1L, (long)mine.size());
        Assert.assertNotNull((Object)other);
        Assert.assertEquals((String)"missing revisions size diffier: ", (long)1L, (long)other.size());
        for (IBazaarLogMessage logMessage : mine) {
            Assert.assertEquals((Object)"quickdiff-integration", (Object)logMessage.getBranchNick());
            Assert.assertEquals((Object)"Guillermo Gonzalez <antiSpam@mail.com>", (Object)logMessage.getCommiter().trim());
            Assert.assertEquals((Object)"116", (Object)logMessage.getRevision().getValue());
            Assert.assertEquals((Object)"Fri 2007-12-21 19:34:45 -0300", (Object)logMessage.getTimeStamp());
            Assert.assertEquals((Object)StringUtil.parseLogDate((String)"Fri 2007-12-21 19:34:45 -0300"), (Object)logMessage.getDate());
            Assert.assertNotNull(null, (Object)logMessage.getMerged());
            Assert.assertEquals((long)0L, (long)logMessage.getMerged().size());
        }
        for (IBazaarLogMessage logMessage : other) {
            Assert.assertEquals((Object)"quickdiff-integration", (Object)logMessage.getBranchNick());
            Assert.assertEquals((Object)"Guillermo Gonzalez <antiSpam@mail.com>", (Object)logMessage.getCommiter().trim());
            Assert.assertEquals((Object)"116", (Object)logMessage.getRevision().getValue());
            Assert.assertEquals((Object)"Fri 2007-12-21 19:34:45 -0300", (Object)logMessage.getTimeStamp());
            Assert.assertEquals((Object)StringUtil.parseLogDate((String)"Fri 2007-12-21 19:34:45 -0300"), (Object)logMessage.getDate());
            Assert.assertNotNull(null, (Object)logMessage.getMerged());
            Assert.assertEquals((long)0L, (long)logMessage.getMerged().size());
        }
    }
}

