/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.parser.XMLStatusParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLStatusParserTest
extends ParserTest {
    @Test
    public void testSimpleStatus() throws BazaarClientException, IOException {
        Set statuses = null;
        XMLStatusParser statusParser = new XMLStatusParser();
        statusParser.parse(XMLStatusParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/status.xml"));
        statuses = statusParser.getStatusSet();
        Assert.assertNotNull((Object)statuses);
        Assert.assertFalse((statuses.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"statuses size diffier: ", (long)20L, (long)statuses.size());
        int modified = 0;
        int added = 0;
        int renamed = 0;
        int kindChanged = 0;
        int unknown = 0;
        int xbit = 0;
        for (IBazaarStatus status : statuses) {
            modified = status.contains(BazaarStatusKind.MODIFIED) ? modified + 1 : modified;
            added = status.contains(BazaarStatusKind.CREATED) ? added + 1 : added;
            renamed = status.contains(BazaarStatusKind.RENAMED) && !status.getPreviousPath().isEmpty() ? renamed + 1 : renamed;
            kindChanged = status.contains(BazaarStatusKind.KIND_CHANGED) ? kindChanged + 1 : kindChanged;
            unknown = status.contains(BazaarStatusKind.UNKNOWN) ? unknown + 1 : unknown;
            xbit = status.contains(BazaarStatusKind.X_BIT_CHANGED) ? xbit + 1 : xbit;
        }
        Assert.assertEquals((long)8L, (long)modified);
        Assert.assertEquals((long)4L, (long)added);
        Assert.assertEquals((long)1L, (long)renamed);
        Assert.assertEquals((long)1L, (long)kindChanged);
        Assert.assertEquals((long)7L, (long)unknown);
        Assert.assertEquals((long)2L, (long)xbit);
    }

    @Test
    public void testStatusWithConflicts() throws BazaarClientException, IOException {
        Set statuses = null;
        XMLStatusParser statusParser = new XMLStatusParser();
        statusParser.parse(XMLStatusParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/status_conflicts.xml"));
        statuses = statusParser.getStatusSet();
        Assert.assertNotNull((Object)statuses);
        Assert.assertFalse((statuses.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"statuses size diffier: ", (long)20L, (long)statuses.size());
        int modified = 0;
        int added = 0;
        int renamed = 0;
        int kindChanged = 0;
        int unknown = 0;
        int conflicts = 0;
        for (IBazaarStatus status : statuses) {
            modified = status.contains(BazaarStatusKind.MODIFIED) ? modified + 1 : modified;
            added = status.contains(BazaarStatusKind.CREATED) ? added + 1 : added;
            renamed = status.contains(BazaarStatusKind.RENAMED) ? renamed + 1 : renamed;
            kindChanged = status.contains(BazaarStatusKind.KIND_CHANGED) ? kindChanged + 1 : kindChanged;
            unknown = status.contains(BazaarStatusKind.UNKNOWN) ? unknown + 1 : unknown;
            conflicts = status.contains(BazaarStatusKind.HAS_CONFLICTS) ? conflicts + 1 : conflicts;
        }
        Assert.assertEquals((long)8L, (long)modified);
        Assert.assertEquals((long)4L, (long)added);
        Assert.assertEquals((long)1L, (long)renamed);
        Assert.assertEquals((long)1L, (long)kindChanged);
        Assert.assertEquals((long)7L, (long)unknown);
        Assert.assertEquals((long)1L, (long)conflicts);
    }

    @Test
    public void testStatusWithPendingMerges() throws BazaarClientException, IOException {
        Set statuses = null;
        XMLStatusParser statusParser = new XMLStatusParser();
        statusParser.parse(XMLStatusParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/status_pending_merges.xml"));
        statuses = statusParser.getStatusSet();
        Assert.assertNotNull((Object)statuses);
        Assert.assertFalse((statuses.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"statuses size diffier: ", (long)17L, (long)statuses.size());
        int modified = 0;
        int added = 0;
        int unknown = 0;
        int deleted = 0;
        for (IBazaarStatus status : statuses) {
            modified = status.contains(BazaarStatusKind.MODIFIED) ? modified + 1 : modified;
            added = status.contains(BazaarStatusKind.CREATED) ? added + 1 : added;
            unknown = status.contains(BazaarStatusKind.UNKNOWN) ? unknown + 1 : unknown;
            deleted = status.contains(BazaarStatusKind.DELETED) ? deleted + 1 : deleted;
        }
        Assert.assertEquals((long)8L, (long)modified);
        Assert.assertEquals((long)1L, (long)added);
        Assert.assertEquals((long)5L, (long)unknown);
        Assert.assertEquals((long)3L, (long)deleted);
        List pendingMerges = statusParser.getPendingMerges();
        Assert.assertEquals((long)2L, (long)pendingMerges.size());
        for (IBazaarLogMessage pending : pendingMerges) {
            Assert.assertNotNull((Object)pending.getRevisionId());
            Assert.assertNotNull((Object)pending.getTimeStamp());
        }
    }
}

