/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.testUtils;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ExpectedStructureFactory;
import org.vcs.bazaar.client.testUtils.ExpectedWorkingTree;
import org.vcs.bazaar.client.testUtils.FileUtils;

@Ignore
public final class TestsConfig {
    private static final Log LOG = LogFactory.getLog(TestsConfig.class);
    private static TestsConfig testsConfig;
    public String clientType;
    public File rootDir;
    public String rootDirName;
    public File workingCopies;
    public IBazaarClient client;
    public File defaultWorkingTreeLocation;
    public ExpectedWorkingTree defaultWorkingTree;
    private static String username;
    private static String usermail;

    private TestsConfig() throws Exception {
        LOG.debug((Object)"Initializing client factories");
        try {
            BazaarClientFactory.setupBestAvailableBackend((boolean)true);
        }
        catch (BazaarClientException e) {
            LOG.error((Object)"Error initializing bzr backend", (Throwable)e);
            throw e;
        }
        this.clientType = BazaarClientPreferences.getInstance().getString(BazaarPreference.TEST_CLIENT_TYPE);
        if (this.clientType == null) {
            this.clientType = BazaarClientFactory.getPreferredClientType();
        }
        this.configureClient();
        this.rootDir = FileUtils.createTempDir("bazaar_client_tests", "");
        this.workingCopies = new File(this.rootDir, "working_copies");
        if (this.workingCopies.exists()) {
            LOG.debug((Object)"working_copies dir already exists, deleting it...");
            FileUtils.removeDirectoryWithContent(this.workingCopies);
        }
        this.workingCopies.mkdirs();
        this.defaultWorkingTreeLocation = new File(this.workingCopies, "default_branch");
        this.defaultWorkingTree = ExpectedStructureFactory.getWorkingTree();
    }

    public void createWorkingTree() throws Exception {
        this.defaultWorkingTreeLocation.mkdir();
        this.defaultWorkingTree.materialize(this.defaultWorkingTreeLocation);
        LOG.debug((Object)("Creating branch:" + this.defaultWorkingTreeLocation.toString()));
        File[] filesToAdd = this.defaultWorkingTreeLocation.listFiles();
        this.client.setWorkDir(this.defaultWorkingTreeLocation);
        this.client.init(this.defaultWorkingTreeLocation, new Option[0]);
        this.client.add(filesToAdd, new Option[0]);
        this.client.commit(new File[]{this.defaultWorkingTreeLocation}, "initial import", new Option[0]);
    }

    public void deleteWorkingTree() {
        FileUtils.removeDirectoryWithContent(this.rootDir);
    }

    private void configureClient() {
        LOG.info((Object)("Using client: " + this.clientType));
        this.client = BazaarClientFactory.createClient((String)this.clientType);
    }

    public static TestsConfig getTestsConfig() throws Exception {
        if (testsConfig == null) {
            testsConfig = new TestsConfig();
        }
        return testsConfig;
    }

    public static String getUserName() {
        return username + " <" + usermail + ">";
    }

    public static String getBzrMail() {
        return usermail;
    }

    static {
        username = "bzr-eclipse-user";
        usermail = "bzr-eclipse-user@bzr.org";
        LOG.debug((Object)"Getting environment settings");
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        try {
            InputStream is = TestsConfig.class.getResourceAsStream("/tests.properties");
            Properties fileProps = new Properties();
            if (is != null) {
                fileProps.load(is);
                prefs.setFrom(fileProps);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Trouble getting environment settings", (Throwable)e);
        }
        if (prefs.getString(BazaarPreference.TEST_USER_NAME) != null) {
            username = prefs.getString(BazaarPreference.TEST_USER_NAME);
        }
        if (prefs.getString(BazaarPreference.TEST_USER_MAIL) != null) {
            usermail = prefs.getString(BazaarPreference.TEST_USER_MAIL);
        }
        prefs.set(BazaarPreference.BZR_EMAIL, TestsConfig.getUserName());
        if (prefs.getString(BazaarPreference.EXECUTABLE) == null) {
            prefs.set(BazaarPreference.EXECUTABLE, "bzr");
        }
    }
}

