/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.util.LinkedHashMap;
import java.util.Map;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.CommandLineClient;
import org.vcs.bazaar.client.commandline.CommandLineClientFactory;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.xmlrpc.XmlRpcClientFactory;

public abstract class BazaarClientFactory {
    private static Map<String, BazaarClientFactory> factories = new LinkedHashMap<String, BazaarClientFactory>();

    public static IBazaarClient createClient(String clientType) {
        if (factories.containsKey(clientType)) {
            BazaarClientFactory factory = factories.get(clientType);
            try {
                if (factory.isAvailable(false)) {
                    return (CommandLineClient)factory.createClientImpl();
                }
            }
            catch (BazaarClientException bazaarClientException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String setupBestAvailableBackend(boolean force) throws BazaarClientException {
        BazaarClientException exc = null;
        for (BazaarClientFactory factory : factories.values()) {
            try {
                if (!factory.isAvailable(force)) continue;
                return factory.getClientType();
            }
            catch (BazaarClientException e) {
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
        throw new BazaarClientException("No client factory found");
    }

    protected static void registerAdapterFactory(BazaarClientFactory newFactory) {
        factories.put(newFactory.getClientType(), newFactory);
    }

    public static String[] getClientTypes() {
        return factories.keySet().toArray(new String[0]);
    }

    public static String getPreferredClientType() throws BazaarClientException {
        return BazaarClientFactory.setupBestAvailableBackend(false);
    }

    public static final boolean isClientTypeAvailable(String clientType) {
        return BazaarClientFactory.createClient(clientType) != null;
    }

    protected abstract IBazaarClient createClientImpl();

    protected abstract String getClientType();

    protected abstract boolean isAvailable(boolean var1) throws BazaarClientException;

    static {
        BazaarClientFactory.registerAdapterFactory(new XmlRpcClientFactory());
        BazaarClientFactory.registerAdapterFactory(new CommandLineClientFactory());
    }
}

