/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.BazaarUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BazaarClientPreferences {
    private static final Log LOG = LogFactory.getLog(BazaarClientPreferences.class);
    private static final BazaarClientPreferences instance = new BazaarClientPreferences();
    private final HashMap<BazaarPreference, String> preferenceMap = new HashMap();
    private String autodetectedExecutable;

    private BazaarClientPreferences() {
        try {
            File bzr = BazaarUtilities.findExecutable();
            this.autodetectedExecutable = bzr.getPath();
            this.preferenceMap.put(BazaarPreference.EXECUTABLE, bzr.getPath());
        }
        catch (FileNotFoundException e) {
            this.preferenceMap.put(BazaarPreference.EXECUTABLE, "bzr");
        }
        for (BazaarPreference pref : BazaarPreference.values()) {
            if (BazaarClientPreferences.getSystemEnv(pref) == null) continue;
            this.preferenceMap.put(pref, BazaarClientPreferences.getSystemEnv(pref));
        }
    }

    public void fillFrom(Properties properties) {
        for (BazaarPreference pref : BazaarPreference.values()) {
            if (this.preferenceMap.get((Object)pref) != null) continue;
            this.preferenceMap.put(pref, BazaarClientPreferences.getValue(properties, pref));
        }
    }

    public void setFrom(Properties properties) {
        for (BazaarPreference pref : BazaarPreference.values()) {
            this.preferenceMap.put(pref, BazaarClientPreferences.getValue(properties, pref));
        }
    }

    public static final BazaarClientPreferences getInstance() {
        return instance;
    }

    public String getString(BazaarPreference value) {
        return this.preferenceMap.get((Object)value);
    }

    public final void set(BazaarPreference key, String value) {
        this.preferenceMap.put(key, value);
    }

    public final void unset(BazaarPreference key) {
        this.preferenceMap.remove((Object)key);
    }

    public static final List<String> getExecutable() {
        return BazaarClientPreferences.getExecutable(true);
    }

    public static final List<String> getExecutable(boolean forceCLI) {
        String exe = BazaarClientPreferences.getInstance().getString(BazaarPreference.EXECUTABLE);
        boolean isCLI = true;
        try {
            isCLI = forceCLI || BazaarClientFactory.getPreferredClientType().equals("CommandLine");
        }
        catch (BazaarClientException e) {
            LOG.info((Object)e.getMessage());
        }
        if (exe.toLowerCase().endsWith(".bat") && isCLI) {
            try {
                return BazaarUtilities.getWindowsExecutable(exe);
            }
            catch (IOException e) {
                LOG.error((Object)"IO trouble while parsing bzr.bat", (Throwable)e);
            }
        }
        ArrayList<String> output = new ArrayList<String>();
        output.add(exe);
        return output;
    }

    public final Map<String, String> getPreferences() {
        HashMap<String, String> newMap = new HashMap<String, String>(this.preferenceMap.size() - 1);
        for (BazaarPreference key : this.preferenceMap.keySet()) {
            if (BazaarPreference.EXECUTABLE.equals((Object)key) || BazaarPreference.BZR_PROGRESS_BAR.equals((Object)key) || this.preferenceMap.get((Object)key) == null) continue;
            newMap.put(key.name(), this.preferenceMap.get((Object)key));
        }
        return newMap;
    }

    public final Map<BazaarPreference, String> asMap() {
        HashMap<BazaarPreference, String> newMap = new HashMap<BazaarPreference, String>(this.preferenceMap.size() - 1);
        for (BazaarPreference key : this.preferenceMap.keySet()) {
            newMap.put(key, this.preferenceMap.get((Object)key));
        }
        return newMap;
    }

    private static String getSystemEnv(BazaarPreference pref) {
        return BazaarClientPreferences.getValue(null, pref);
    }

    private static String getValue(Properties properties, BazaarPreference pref) {
        if (properties != null) {
            return properties.getProperty(pref.toString(), System.getProperty(pref.toString()));
        }
        return System.getProperty(pref.toString());
    }

    public String getAutodetectedExecutable() {
        return this.autodetectedExecutable;
    }
}

