/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.core.BazaarClientException;

public final class BazaarRevision
implements IBazaarRevisionSpec {
    private static final long serialVersionUID = 5167232866997237544L;
    public static final BazaarRevision INVALID = new BazaarRevision(Prefix.NONE, null);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
    private final Prefix prefix;
    private final String value;

    private BazaarRevision(Prefix prefix, String value) {
        this.prefix = prefix;
        this.value = value != null ? value.trim() : value;
    }

    private BazaarRevision(String prefix, String value) {
        this.prefix = Prefix.fromString(prefix);
        this.value = value != null ? value.trim() : value;
    }

    public String toString() {
        return this.prefix != null ? this.prefix.toString().concat(this.value) : "";
    }

    public static final BazaarRevision getRevision(String prefixKind, String value) {
        if (Prefix.isValid(prefixKind)) {
            return new BazaarRevision(prefixKind, value);
        }
        throw BazaarClientException.makeUnChecked(new BazaarClientException("Invalid revision format"));
    }

    public static final BazaarRevision getRevision(Prefix prefix, String value) {
        return new BazaarRevision(prefix, value);
    }

    public static final BazaarRevision getRevision(Date date) {
        return new BazaarRevision(Prefix.DATE, BazaarRevision.format(date));
    }

    protected static synchronized String format(Date date) {
        return dateFormat.format(date);
    }

    public static final BazaarRevision getRevision(int revision) {
        return new BazaarRevision(Prefix.REVNO, String.valueOf(revision));
    }

    public final Prefix getPrefix() {
        return this.prefix;
    }

    public final String getValue() {
        return this.value;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BazaarRevision other = (BazaarRevision)obj;
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals((Object)other.prefix)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int compareTo(BazaarRevision other) {
        if (this.value == null && other.getValue() == null) {
            return 0;
        }
        if (this.value == null) {
            return -1;
        }
        if (other.getValue() == null) {
            return 1;
        }
        if (this.prefix == Prefix.REVID) {
            return this.value.compareTo(other.getValue());
        }
        StringTokenizer thisTokens = new StringTokenizer(this.value, ".");
        StringTokenizer otherTokens = new StringTokenizer(other.getValue(), ".");
        int result = 0;
        while (result == 0) {
            Integer thisToken = null;
            try {
                thisToken = Integer.valueOf(thisTokens.nextToken());
            }
            catch (Exception ex) {
                // empty catch block
            }
            Integer otherToken = null;
            try {
                otherToken = Integer.valueOf(otherTokens.nextToken());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (thisToken == null) {
                if (otherToken == null) break;
                result = 1;
                continue;
            }
            if (otherToken == null) {
                result = -1;
                continue;
            }
            if (result != 0) continue;
            result = thisToken.compareTo(otherToken);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prefix {
        REVNO("revno:"),
        REVID("revid:"),
        LAST("last:"),
        BEFORE("before:"),
        TAG("tag:"),
        DATE("date:"),
        ANCESTOR("ancestor:"),
        BRANCH("branch:"),
        NONE("");

        private final String value;

        private Prefix(String value) {
            this.value = value;
        }

        protected static boolean isValid(String value) {
            return Prefix.fromString(value) != null;
        }

        public static Prefix fromString(String prefixString) {
            for (Prefix prefix : Prefix.values()) {
                if (!prefix.value.equals(prefixString)) continue;
                return prefix;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

