/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.utils.BazaarUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarStatus
implements IBazaarStatus {
    private static final long serialVersionUID = -7488117153422171224L;
    protected final EnumSet<BazaarStatusKind> statuses = EnumSet.noneOf(BazaarStatusKind.class);
    protected final File branchRoot;
    protected final File file;
    protected final boolean directory;

    public static IBazaarStatus create(File path, boolean directory, File branchRoot, BazaarStatusKind ... status) {
        ArrayList<BazaarStatusKind> statuses = new ArrayList<BazaarStatusKind>(1);
        for (BazaarStatusKind kind : status) {
            statuses.add(kind);
        }
        return new BazaarStatus(statuses, path, directory, branchRoot);
    }

    public BazaarStatus(File path, boolean directory, File branchRoot) {
        this.branchRoot = branchRoot;
        this.file = path;
        this.directory = directory;
    }

    public BazaarStatus(List<BazaarStatusKind> statuses, File path, boolean directory, File branchRoot) {
        this(path, directory, branchRoot);
        this.statuses.addAll(statuses);
    }

    @Override
    public boolean contains(BazaarStatusKind kind) {
        return this.statuses.contains((Object)kind);
    }

    @Override
    public String getAbsolutePath() {
        return BazaarUtilities.unixFilePath(new File(this.getBranchRoot(), this.getPath()));
    }

    @Override
    public File getBranchRoot() {
        return this.branchRoot;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getNewKind() {
        return null;
    }

    @Override
    public String getOldKind() {
        return null;
    }

    @Override
    public String getPath() {
        if (this.file != null) {
            return BazaarUtilities.unixFilePath(this.file);
        }
        return "";
    }

    @Override
    public File getPreviousFile() {
        return null;
    }

    @Override
    public String getPreviousPath() {
        return null;
    }

    @Override
    public String getShortStatus() {
        StringBuilder versioned = new StringBuilder();
        StringBuilder content = new StringBuilder();
        StringBuilder execute = new StringBuilder();
        for (BazaarStatusKind kind : this.statuses) {
            if (kind.getCategory() == BazaarStatusKind.Category.VERSIONED) {
                versioned.append(kind.toChar());
            }
            if (kind.getCategory() == BazaarStatusKind.Category.CONTENT) {
                content.append(kind.toChar());
            }
            if (kind.getCategory() != BazaarStatusKind.Category.EXECUTABLE) continue;
            execute.append(kind.toChar());
        }
        return versioned.append(content.toString()).append(execute.toString()).toString();
    }

    @Override
    public Collection<? extends BazaarStatusKind> getStatuses() {
        return this.statuses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortStatus()).append(" ");
        sb.append(this.getPath()).append(" ");
        return sb.toString();
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IBazaarStatus) {
            boolean equalPath = ((IBazaarStatus)obj).getPath().equals(this.getPath());
            return equalPath && this.statuses.containsAll(((IBazaarStatus)obj).getStatuses());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.branchRoot == null ? 0 : this.branchRoot.hashCode());
        return result;
    }
}

