/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.Serializable;
import org.vcs.bazaar.client.BazaarRevision;

public final class BazaarVersionInfo
implements Serializable {
    private static final long serialVersionUID = -3523232917564159330L;
    private final BazaarRevision revno;
    private final BazaarRevision revid;
    private final String branchNick;
    private final String date;
    private final String buildDate;

    public static BazaarVersionInfo parse(String versionInfoStr) {
        String[] lines = versionInfoStr.split("\n");
        BazaarRevision revid = BazaarRevision.getRevision(BazaarRevision.Prefix.REVID, lines[0].split(":")[1]);
        String date = lines[1].split(":")[1];
        String buildDate = lines[2].split(":")[1];
        BazaarRevision revno = BazaarRevision.getRevision(BazaarRevision.Prefix.REVNO, lines[3].split(":")[1]);
        String nick = lines[4].split(":")[1];
        return new BazaarVersionInfo(revno, revid, nick, date, buildDate);
    }

    private BazaarVersionInfo(BazaarRevision revno, BazaarRevision revid, String branchNick, String date, String buildDate) {
        this.revno = revno;
        this.revid = revid;
        this.branchNick = branchNick;
        this.date = date;
        this.buildDate = buildDate;
    }

    public BazaarRevision getRevno() {
        return this.revno;
    }

    public BazaarRevision getRevid() {
        return this.revid;
    }

    public String getBranchNick() {
        return this.branchNick;
    }

    public String getDate() {
        return this.date;
    }

    public String getBuildDate() {
        return this.buildDate;
    }
}

