/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import java.io.File;
import java.io.IOException;
import org.vcs.bazaar.client.IBazaarAnnotation;
import org.vcs.bazaar.client.commandline.parser.XMLAnnotateParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

public class CommandLineAnnotation
implements IBazaarAnnotation {
    private static final long serialVersionUID = -1365055126599967682L;
    private final String[] revisionByLine;
    private final String[] authorByLine;
    private final String[] dateByLine;
    private final String[] lines;
    private final String[] filesIds;
    private final File file;
    private final File branchRoot;
    private final int numberOflines;

    protected CommandLineAnnotation(String[] revsionByLine, String[] authorByLine, String[] dateByLine, String[] lines, String[] filesIds, File file, File branchRoot) {
        this.revisionByLine = revsionByLine;
        this.authorByLine = authorByLine;
        this.dateByLine = dateByLine;
        this.lines = lines;
        this.filesIds = filesIds;
        this.file = file;
        this.branchRoot = branchRoot;
        this.numberOflines = lines.length;
    }

    public static IBazaarAnnotation getAnnotationFromXml(String annoatexmlOutput) throws BazaarClientException {
        CommandLineAnnotation ann;
        XMLAnnotateParser parser = new XMLAnnotateParser();
        try {
            parser.parse(annoatexmlOutput);
            ann = new CommandLineAnnotation(parser.getRevisions(), parser.getAuthors(), parser.getDates(), parser.getLines(), parser.getFileIds(), parser.getFile(), parser.getBranchRoot());
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        return ann;
    }

    public String getAuthor(int lineNumber) {
        return this.authorByLine[lineNumber];
    }

    public String getDate(int lineNumber) {
        return this.dateByLine[lineNumber];
    }

    public int getNumberOfLines() {
        return this.numberOflines;
    }

    public String getRevision(int lineNumber) {
        return this.revisionByLine[lineNumber];
    }

    public String getline(int lineNumber) {
        return this.lines[lineNumber];
    }

    public String getFileId(int lineNumber) {
        return this.filesIds[lineNumber];
    }

    public File getBranchRoot() {
        return this.branchRoot;
    }

    public File getFile() {
        return this.file;
    }
}

