/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.CommandLineClient;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.BazaarUtilities;

public class CommandLineClientFactory
extends BazaarClientFactory {
    public static final String CLIENT_TYPE = "CommandLine";
    protected boolean alreadyAskedForAvailability;
    protected boolean available;
    private static final int[] XMLOUTPUT_VERSION = new int[]{0, 9, 2};
    private static final int POINT = 2;
    private static final int MINOR = 1;
    private static final int MAJOR = 0;

    protected IBazaarClient createClientImpl() {
        return new CommandLineClient(new CommandLineNotificationHandler());
    }

    protected String getClientType() {
        return CLIENT_TYPE;
    }

    public static boolean checkXmlOutputVersion(int[] requiredVersion) {
        int required;
        int major;
        int minor;
        String[] version = null;
        try {
            version = BazaarUtilities.getXmlOutputVersion();
        }
        catch (BazaarClientException e) {
            // empty catch block
        }
        if (version == null || version.length == 0) {
            return false;
        }
        int point = Integer.valueOf(version[2]);
        int actual = point + (minor = Integer.valueOf(version[1]).intValue()) * 100 + (major = Integer.valueOf(version[0]).intValue()) * 10000;
        return actual >= (required = requiredVersion[2] + requiredVersion[1] * 100 + requiredVersion[0] * 10000);
    }

    protected boolean isAvailable(boolean force) throws BazaarClientException {
        boolean bl = force ? !force : (this.alreadyAskedForAvailability = this.alreadyAskedForAvailability);
        if (!this.alreadyAskedForAvailability) {
            BazaarUtilities.checkExecutable();
            this.available = CommandLineClientFactory.checkXmlOutputVersion(XMLOUTPUT_VERSION);
            if (!this.available) {
                StringBuilder requiredVersion = new StringBuilder();
                requiredVersion.append(XMLOUTPUT_VERSION[0]).append(".");
                requiredVersion.append(XMLOUTPUT_VERSION[1]).append(".");
                requiredVersion.append(XMLOUTPUT_VERSION[2]);
                throw new BazaarClientException("xmloutput >= " + requiredVersion.toString() + " plugin not found");
            }
            this.alreadyAskedForAvailability = this.available;
        }
        return this.available;
    }
}

