/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;

public abstract class CommandRunner {
    protected final BazaarClientPreferences preferences;
    private static HashMap<String, String> DEFAULT_ENVIROMENT = new HashMap();
    protected String stderr;
    protected String stdout;
    protected IBazaarPromptUserPassword userPasswordPrompt;

    public CommandRunner(BazaarClientPreferences preferences) {
        this.preferences = preferences;
    }

    public abstract void runCommand(Command var1, File var2) throws IOException, InterruptedException, BazaarClientException;

    public String getStandardError() {
        return this.stderr;
    }

    public String getStandardOutput() {
        return this.stdout;
    }

    public String getStandardOutput(String charsetName) throws UnsupportedEncodingException {
        return new String(this.stdout.getBytes(), charsetName);
    }

    public String[] getStandardOutputSplit() {
        String[] result = this.getStandardOutput().trim().split(this.getSplitExpression());
        if (result.length == 1 && result[0].isEmpty()) {
            result = new String[]{};
        }
        return result;
    }

    protected abstract String getSplitExpression();

    public static void setDefaultEnviroment(ProcessBuilder pb, BazaarClientPreferences preferences) {
        Map<String, String> env = pb.environment();
        env.putAll(DEFAULT_ENVIROMENT);
        env.putAll(preferences.getPreferences());
    }

    protected String decodeXMLOutput(byte[] output) {
        if (output == null) {
            return null;
        }
        String decodedWithDefaultCharset = new String(output);
        String stringEncoding = XMLParser.getDeclaredEncoding(decodedWithDefaultCharset);
        if (stringEncoding == null) {
            return decodedWithDefaultCharset;
        }
        try {
            return new String(output, stringEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return decodedWithDefaultCharset;
        }
    }

    public void setPasswordCallback(IBazaarPromptUserPassword callback) {
        this.userPasswordPrompt = callback;
    }

    public BazaarClientPreferences getPreferences() {
        return this.preferences;
    }

    static {
        DEFAULT_ENVIROMENT.put(BazaarPreference.BZR_PROGRESS_BAR.name(), "xmlrpc");
    }
}

