/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLAnnotateParser
extends XMLParser {
    private static final Log LOG = LogFactory.getLog(XMLAnnotateParser.class);
    private final List<String> revisionByLine = new ArrayList<String>();
    private final List<String> authorByLine = new ArrayList<String>();
    private final List<String> dateByLine = new ArrayList<String>();
    private final List<String> fidByLine = new ArrayList<String>();
    private final List<String> lines = new ArrayList<String>();
    File branchRoot;
    File file;
    private static final String ANNOTATE = "annotation";
    private static final String FILE = "file";
    private static String BRANCH_ROOT = "workingtree-root";
    private static final String ENTRY = "entry";
    private static final String REVISION = "revno";
    private static final String FID = "fid";
    private static final String AUTHOR = "author";
    private static final String DATE = "date";

    public void parse(String xml) throws XmlPullParserException, IOException {
        this.parser = new KXmlParser();
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && ANNOTATE.equals(this.parser.getName())) {
                    this.branchRoot = new File(this.parser.getAttributeValue(null, BRANCH_ROOT));
                    this.file = new File(this.parser.getAttributeValue(null, FILE));
                    this.parseAnnotate();
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            LOG.error((Object)"XML parsing failed", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)"IO trouble while parsing XML", (Throwable)e);
            throw e;
        }
    }

    private void parseAnnotate() throws XmlPullParserException, IOException {
        this.revisionByLine.clear();
        this.authorByLine.clear();
        this.dateByLine.clear();
        this.lines.clear();
        this.fidByLine.clear();
        int eventType = this.parser.next();
        while (eventType != 1 || eventType == 3 && ANNOTATE.equals(this.parser.getName())) {
            if (eventType == 2 && ENTRY.equals(this.parser.getName())) {
                String line = null;
                String date = null;
                String author = null;
                String fid = null;
                String revno = null;
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    if (REVISION.equals(this.parser.getAttributeName(i))) {
                        revno = this.parser.getAttributeValue(i);
                        continue;
                    }
                    if (FID.equals(this.parser.getAttributeName(i))) {
                        fid = this.parser.getAttributeValue(i);
                        continue;
                    }
                    if (AUTHOR.equals(this.parser.getAttributeName(i))) {
                        author = this.parser.getAttributeValue(i);
                        continue;
                    }
                    if (!DATE.equals(this.parser.getAttributeName(i))) continue;
                    date = this.parser.getAttributeValue(i);
                }
                line = this.parser.nextText();
                this.revisionByLine.add(revno);
                this.fidByLine.add(fid);
                this.authorByLine.add(author);
                this.dateByLine.add(date);
                this.lines.add(line);
            }
            eventType = this.parser.next();
        }
    }

    public String[] getAuthors() {
        return this.authorByLine.toArray(new String[0]);
    }

    public String[] getDates() {
        return this.dateByLine.toArray(new String[0]);
    }

    public String[] getFileIds() {
        return this.fidByLine.toArray(new String[0]);
    }

    public String[] getRevisions() {
        return this.revisionByLine.toArray(new String[0]);
    }

    public String[] getLines() {
        return this.lines.toArray(new String[0]);
    }

    public File getFile() {
        return new File(this.branchRoot, this.file.getPath());
    }

    public File getBranchRoot() {
        return this.branchRoot;
    }
}

