/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.CommandLineLogMessage;
import org.vcs.bazaar.client.commandline.parser.XMLLogParser;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMissingParser
extends XMLParser {
    private static final String OTHER = "OTHER";
    private static final String MINE = "MINE";
    private static final String MISSING = "missing";
    private static final String LAST_LOCATION = "last_location";
    private static final String MISSING_REVISIONS = "missing_revisions";
    private static final String EXTRA_REVISIONS = "extra_revisions";

    public Map<String, List<IBazaarLogMessage>> parse(String xml) throws BazaarClientException {
        HashMap<String, List<IBazaarLogMessage>> missingOutput = new HashMap<String, List<IBazaarLogMessage>>(2);
        this.parser = new KXmlParser();
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            this.parser.nextTag();
            this.parser.require(2, null, MISSING);
            this.parser.nextTag();
            this.parser.require(2, null, LAST_LOCATION);
            this.parser.nextText();
            this.parser.nextTag();
            try {
                this.parser.require(2, null, EXTRA_REVISIONS);
                missingOutput.put(MINE, this.parseLogs(EXTRA_REVISIONS));
                this.parser.nextTag();
                this.parser.nextTag();
            }
            catch (XmlPullParserException e) {
                // empty catch block
            }
            try {
                this.parser.require(2, null, MISSING_REVISIONS);
                missingOutput.put(OTHER, this.parseLogs(MISSING_REVISIONS));
            }
            catch (XmlPullParserException e) {}
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        return missingOutput;
    }

    private List<IBazaarLogMessage> parseLogs(String section) throws BazaarClientException {
        ArrayList<IBazaarLogMessage> logs = new ArrayList<IBazaarLogMessage>();
        XMLLogParser logParser = new XMLLogParser();
        logParser.parser = this.parser;
        try {
            int eventType = this.parser.nextTag();
            while (eventType != 3 && !section.equals(this.parser.getName())) {
                CommandLineLogMessage log;
                if (eventType == 2 && "log".equals(this.parser.getName()) && (log = logParser.parseLog()) != null) {
                    logs.add(log);
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        return logs;
    }
}

