/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLinePlugin;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPluginParser
extends XMLParser {
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN = "plugin";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String PATH = "path";
    private static final String DOC = "doc";
    private Set<IPlugin> plugins;

    public Set<IPlugin> parse(String xml) throws BazaarClientException {
        this.parser = new KXmlParser();
        this.plugins = new HashSet<IPlugin>();
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            this.parser.nextTag();
            this.parser.require(2, null, PLUGINS);
            while (this.parser.nextTag() == 2) {
                this.parser.require(2, null, PLUGIN);
                this.parser.nextTag();
                this.parser.require(2, null, NAME);
                String name = this.parser.nextText();
                this.parser.nextTag();
                this.parser.require(2, null, VERSION);
                String version = this.parser.nextText();
                this.parser.nextTag();
                this.parser.require(2, null, PATH);
                String path = this.parser.nextText();
                this.parser.nextTag();
                String doc = null;
                try {
                    this.parser.require(2, null, DOC);
                    doc = this.parser.nextText();
                    this.parser.nextTag();
                }
                catch (XmlPullParserException e) {
                    // empty catch block
                }
                this.plugins.add(new CommandLinePlugin(doc != null ? doc.trim() : null, name != null ? name.trim() : null, path != null ? path.trim() : null, version != null ? version.trim() : null));
            }
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        return this.plugins;
    }
}

